import { useContext } from 'react';
import type { TwitchIntl } from 'twitch-intl';
import { intlContext } from '../TachyonIntlRoot';

/**
 * Hook that returns an instance of TachyonIntl, providing methods such as
 * formatMessage and formatNumber. These methods must be destructured for
 * proper functionality; formatMessage will work but intl.formatMessage will
 * not get picked up by the current tooling.
 */
export function useIntl(): TwitchIntl {
  return useContext(intlContext).intl;
}
