import type { FC } from 'react';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { useIntl } from '.';

describe(useIntl, () => {
  const TestElement: FC = () => {
    const intl = useIntl();
    return <>{intl.formatMessage('Test Text', 'useIntlTest')}</>;
  };

  const TestWrapper: FC = () => {
    return <TestElement />;
  };
  const setup = createMountWrapperFactory(TestWrapper);

  it('can call formatMessage', () => {
    const { wrapper } = setup();
    expect(wrapper.find(TestElement).text()).toBe('Test Text');
  });
});
