import type { CountryCode } from './country-codes';

export { CountryCode } from './country-codes';

/**
 * checks if the input string is a recognizable locale in the format of `en-US` or `de-DE`
 */
export const isValidLocale = (localeString: string): boolean => {
  const [lang = '', country = ''] = localeString.split('-');
  return (
    lang.length === 2 &&
    country.length === 2 &&
    lang.toLowerCase() === lang &&
    country.toUpperCase() === country
  );
};

export const isCurrentUserCountrySupported = (
  currentLocale: string,
  countries: CountryCode[],
): boolean => {
  if (!isValidLocale(currentLocale)) {
    return false;
  }

  const [, userCountryCode] = currentLocale.split('-');

  return ([] as string[])
    .concat(countries)
    .some(
      (countryCode) =>
        countryCode.toUpperCase() === userCountryCode.toUpperCase(),
    );
};
