import { CountryCode } from './country-codes';
import { isCurrentUserCountrySupported, isValidLocale } from '.';

describe(isValidLocale, () => {
  it('returns true when locale is valid', () => {
    expect(isValidLocale('en-US')).toBe(true);
  });
  it('returns false on invalid locale', () => {
    expect(isValidLocale('en')).toBe(false);
  });
  it('returns false on valid weirdly formatted locale', () => {
    expect(isValidLocale('En_uS')).toBe(false);
  });
});

describe(isCurrentUserCountrySupported, () => {
  let mockLocale = 'en-US';
  it('returns true when current country code matches current locale', () => {
    expect(
      isCurrentUserCountrySupported(mockLocale, [
        CountryCode.Germany,
        CountryCode.France,
        CountryCode.UnitedStates,
      ]),
    ).toBe(true);
  });
  it('returns false when current country code does not match current locale', () => {
    expect(
      isCurrentUserCountrySupported(mockLocale, [
        CountryCode.Germany,
        CountryCode.France,
        CountryCode.Uzbekistan,
      ]),
    ).toBe(false);
  });
  it('returns false when current country code is invalid', () => {
    mockLocale = 'zzz';
    expect(
      isCurrentUserCountrySupported(mockLocale, [
        CountryCode.Germany,
        CountryCode.France,
        CountryCode.UnitedStates,
      ]),
    ).toBe(false);
  });
});
