/**
 * Function to verify that a browser implements a sufficient set of APIs to be
 * able to support the latency tracker.
 */
// istanbul ignore next: trivial
export function isSafeToTrackLatency(): boolean {
  // domInteractive is the only timing we don't check for since it isn't
  // guaranteed to have happened yet
  return !!(
    typeof window !== 'undefined' &&
    window.performance &&
    window.performance.mark &&
    window.performance.measure &&
    window.performance.getEntriesByName &&
    window.performance.timing &&
    window.performance.timing.navigationStart &&
    window.performance.timing.connectEnd &&
    window.performance.timing.connectStart &&
    window.performance.timing.requestStart &&
    window.performance.timing.responseStart
  );
}
