import type { FC } from 'react';
import { useEffectOnce } from 'tachyon-utils-react';
import { useLatencyTransitionComplete } from '../context';
import type { SignalTransitionCompleteOpts } from '../createLatencyReporter';

type LatencyTransitionCompleteProps = SignalTransitionCompleteOpts;

/**
 * A component for declaratively signalling that a transition has completed.
 * This can be placed inside your "received data" branch of a parent component
 * responsible for rendering loading/success/error, for instance.
 */
// istanbul ignore next: trivial
export const LatencyTransitionComplete: FC<LatencyTransitionCompleteProps> = ({
  requiresJsForInteractivity,
}) => {
  const reportTransitionComplete = useLatencyTransitionComplete();
  useEffectOnce(() => {
    reportTransitionComplete({ requiresJsForInteractivity });
  });

  return null;
};
