import { getPageTimeToInteractive } from '.';

describe(getPageTimeToInteractive, () => {
  const mockMark = jest.fn();
  (window as any).performance = {
    mark: mockMark,
  };

  it('marks for pages that require js', () => {
    // will throw because jsdom mock has no built-in marks
    expect(() =>
      getPageTimeToInteractive({
        pageNumber: 0,
        pageTimeOriginMark: 'navigationStart',
        requiresJsForInteractivity: true,
        skipBackdate: false,
      }),
    ).toThrow();
    expect(mockMark).toHaveBeenCalledWith('Page0End');
  });

  it('marks for all pages that are not the first', () => {
    // will throw because jsdom mock has no built-in marks
    expect(() =>
      getPageTimeToInteractive({
        pageNumber: 1,
        pageTimeOriginMark: 'Page1Start',
        requiresJsForInteractivity: false,
        skipBackdate: false,
      }),
    ).toThrow();
    expect(mockMark).toHaveBeenCalledWith('Page1End');
  });

  it('marks when skipBackdate is true (interstitial locations)', () => {
    // will throw because jsdom mock has no built-in marks
    expect(() =>
      getPageTimeToInteractive({
        pageNumber: 0,
        pageTimeOriginMark: 'navigationStart',
        requiresJsForInteractivity: false,
        skipBackdate: true,
      }),
    ).toThrow();
    expect(mockMark).toHaveBeenCalledWith('Page0End');
  });

  it('does not mark for first pages that do not require js', () => {
    // will throw because jsdom mock has no built-in marks
    expect(() =>
      getPageTimeToInteractive({
        pageNumber: 0,
        pageTimeOriginMark: 'navigationStart',
        requiresJsForInteractivity: false,
        skipBackdate: false,
      }),
    ).toThrow();
    expect(mockMark).not.toHaveBeenCalled();
  });
});
