import type { ReportCustomEvent } from './types';
import { CustomEventGroup, CustomEventKeys } from './types';

export type PublicCustomEventReporters = {
  /**
   * Custom latency benchmark for when chat is connected.
   */
  chatConnected: () => void;
  /**
   * Custom latency benchmark for when player is playing.
   */
  playerPlaying: () => void;
  /**
   * Custom latency benchmark for when player is ready.
   */
  playerReady: () => void;
  /**
   * Custom latency benchmark for when service worker is activated.
   */
  workerActivated: () => void;
  /**
   * Custom latency benchmark for when service worker is controlling browser.
   */
  workerControlling: () => void;
  /**
   * Custom latency benchmark for when service worker is installed.
   */
  workerInstalled: () => void;
  /**
   * Custom latency benchmark for when service worker is waiting.
   */
  workerWaiting: () => void;
};

/**
 * Custom public latency events that are supported
 */
export type CustomLatencyEvent = keyof PublicCustomEventReporters;

// istanbul ignore next: trivial
export function getPublicCustomEventReporters(
  reportCustomEvent: ReportCustomEvent,
): PublicCustomEventReporters {
  return {
    chatConnected: () => {
      reportCustomEvent({
        group: CustomEventGroup.Chat,
        key: CustomEventKeys.ChatConnected,
        label: 'connected',
      });
    },
    playerPlaying: () => {
      reportCustomEvent({
        group: CustomEventGroup.Player,
        key: CustomEventKeys.PlayerPlaying,
        label: 'first frame',
      });
    },
    playerReady: () => {
      reportCustomEvent({
        group: CustomEventGroup.Player,
        key: CustomEventKeys.PlayerReady,
        label: 'loaded',
      });
    },
    workerActivated: () => {
      reportCustomEvent({
        group: CustomEventGroup.ServiceWorker,
        key: CustomEventKeys.WorkerActivated,
        label: 'activated',
      });
    },
    workerControlling: () => {
      reportCustomEvent({
        group: CustomEventGroup.ServiceWorker,
        key: CustomEventKeys.WorkerControlling,
        label: 'controlling',
      });
    },
    workerInstalled: () => {
      reportCustomEvent({
        group: CustomEventGroup.ServiceWorker,
        key: CustomEventKeys.WorkerInstalled,
        label: 'installed',
      });
    },
    workerWaiting: () => {
      reportCustomEvent({
        group: CustomEventGroup.ServiceWorker,
        key: CustomEventKeys.WorkerWaiting,
        label: 'waiting',
      });
    },
  };
}
