import type { LatencyEvent, LatencyFullEvent } from '../LatencyEvent';

/**
 * Parts of the user experience that have special tracking around them.
 */
export enum CustomEventGroup {
  Chat = 'chat',
  Page = 'page',
  Player = 'player',
  ServiceWorker = 'service-worker',
}

/**
 * Standard keys for custom user experience tracking.
 */
export enum CustomEventKeys {
  ChatConnected = 'chat-connected',
  ConnectEnd = 'connect-end',
  FirstByte = 'first-byte',
  FirstCue = 'first-cue',
  PlayerPlaying = 'player-played',
  PlayerReady = 'player-loaded',
  WorkerActivated = 'worker-activated',
  WorkerControlling = 'worker-controlling',
  WorkerInstalled = 'worker-installed',
  WorkerWaiting = 'worker-waiting',
}

/**
 * The type that is necessary to provide for any custom latency tracking
 * events.
 */
export type ReportCustomEventOpts = {
  /**
   * The amount of time from registering this event to the reporting of it. Since
   * a component registers when it starts the task this should equate to the
   * time it takes for the experience to become ready.
   */
  duration?: number;
  /**
   * Seconds since epoch.
   */
  epochTime?: number;
  /**
   * The part of the user experience being tracked.
   */
  group: CustomEventGroup;
  /**
   * The unique identifier associated with the event.
   */
  key: CustomEventKeys;
  /**
   * A human readable string describing the event.
   */
  label: string;
};

export type ReportCustomEvent = (opts: ReportCustomEventOpts) => void;

export type ReportStandardEventOpts = {
  data: LatencyEvent;
  epochTime: number;
};

export type ReportStandardEvent = (opts: ReportStandardEventOpts) => void;

export type OnEvent = (event: LatencyFullEvent) => void;
