# Tachyon Logger

The tachyon logger provides the ability to log to both the local console and to
Sentry. Error messages are sent to Sentry for monitoring, and all other log
entries are collected as breadcrumbs to aid debugging.

## Installation

```sh
$ yarn add tachyon-logger
```

## Usage

The primary usage is via the exported `logger` instance, which exposes all of
the `console` methods (`log`, `error`, etc) and is intended to be used in place
of `console`. `logger`'s method are more opinionated about having a specific
shape in order to enforce more useful data collection for reporting to Sentry.

```ts
import { logger } from 'tachyon-logger';

logger.log({
  category: 'some grouping info',
  message: 'something happened',
  package: 'top-level grouping',
});
```

## Sentry Integration

### Configuration

Without configuration, `logger` will only report to the local console. The
package exports `configureClientLogging` which allows you to pass in your app's
Sentry DSN (among other values which are noted in the TypeDocs). After
successful configuration, `logger` will also report data to Sentry as well.

Currently, the sentry integration is only tested for use in the browser, but
aliasing `@sentry/browser` to `@sentry/node` should make things work server-side
as well.

### log/debug/info/warning

For normal log statements, `logger` will capture them as a breadcrumb for any
errors that arise in the future. This allows you to naturally develop an event
trail in the case that an error occurs. For any given log entry, you can disable
this auto-breadcrumbing with the `localOnly` option. These entries also have an
optional `context` key which accepts a flat object with primitive-only values
for enhanced data collection.

### error

For `console.error` logs, these are reported to Sentry as errors (triggering the
collection of the preceding breadcrumbs). In addition to an error message, error
logs can also have an optional `error` key for accepting an `Error` object and
an optional `level` key for modulating the level of the error. If an `error` is
not passed, the `message` is used as the error text.
