import { isBrowser } from 'tachyon-utils-stdlib';
import { consoleSerialize } from '.';

jest.mock('tachyon-utils-stdlib', () => ({
  isBrowser: jest.fn(),
}));
const mockIsBrowser = isBrowser as jest.Mock;

describe(consoleSerialize, () => {
  beforeEach(() => {
    mockIsBrowser.mockReset();
  });

  const logPayload = {
    a: 1,
  } as any;

  it('returns an object in the browser', () => {
    mockIsBrowser.mockImplementationOnce(() => true);
    expect(consoleSerialize(logPayload)).toEqual(logPayload);
  });

  it('returns a stringified object on the server', () => {
    mockIsBrowser.mockImplementationOnce(() => false);
    expect(consoleSerialize(logPayload)).toEqual('{"a":1}');
  });
});
