/* eslint-disable no-console */

export type ConsoleMethod = 'debug' | 'error' | 'info' | 'log' | 'warn';

/**
 * Temporarily mocks the specified console method, calls the passed in function,
 * and then returns mock for assertions.
 *
 * @param method The console method to capture.
 * @param func A test function to run after replacing the console logging methods.
 */
export function mockConsole(method: ConsoleMethod, func: () => any): jest.Mock {
  const original = console[method];
  const mock = jest.fn();

  console[method] = mock;
  func();
  console[method] = original;

  return mock;
}
