import type { Severity } from '@sentry/browser';
import { addBreadcrumb, withScope } from '@sentry/browser';
import type { LogPayload } from '../types';

export interface RecordBreadcrumbOpts {
  level: Severity;
  logPayload: LogPayload;
}

export function recordBreadcrumb({
  level,
  logPayload: { category, context, localOnly, message, package: packageName },
}: RecordBreadcrumbOpts): void {
  if (!localOnly) {
    withScope((scope) => {
      scope.setTag('package', packageName);

      if (context) {
        scope.setContext('context', context);
      }

      addBreadcrumb({
        category,
        level,
        message,
      });
    });
  }
}
