import { Severity, addBreadcrumb, withScope } from '@sentry/browser';
import { recordBreadcrumb } from '.';

jest.mock('@sentry/browser', () => ({
  ...jest.requireActual('@sentry/browser'),
  addBreadcrumb: jest.fn(),
  withScope: jest.fn(),
}));
const mockAddBreadcrumb = addBreadcrumb as jest.Mock;
const mockWithScope = withScope as jest.Mock;

describe(recordBreadcrumb, () => {
  const mockSetTag = jest.fn();
  const mockSetContext = jest.fn();

  mockWithScope.mockImplementation((cb: any) => {
    const mockScope = {
      setContext: mockSetContext,
      setTag: mockSetTag,
    };

    cb(mockScope);
  });

  const category = 'category';
  const context = { key: 'value' };
  const level = Severity.Info;
  const message = 'message';
  const packageName = 'package';

  it('processes a fully hydrated log payload', () => {
    recordBreadcrumb({
      level,
      logPayload: {
        category,
        context,
        message,
        package: packageName,
      },
    });

    expect(mockSetTag).toHaveBeenCalledTimes(1);
    expect(mockSetTag).toHaveBeenCalledWith('package', packageName);

    expect(mockSetContext).toHaveBeenCalledTimes(1);
    expect(mockSetContext).toHaveBeenCalledWith('context', context);

    expect(mockAddBreadcrumb).toHaveBeenCalledWith({
      category,
      level,
      message,
    });
  });

  it('process a minimal log payload', () => {
    recordBreadcrumb({
      level,
      logPayload: {
        category,
        message,
        package: packageName,
      },
    });

    expect(mockSetTag).toHaveBeenCalledTimes(1);
    expect(mockSetTag).toHaveBeenCalledWith('package', packageName);

    expect(mockSetContext).not.toHaveBeenCalled();

    expect(mockAddBreadcrumb).toHaveBeenCalledWith({
      category,
      level,
      message,
    });
  });

  it('does not report when payload has localOnly', () => {
    recordBreadcrumb({
      level,
      logPayload: {
        category,
        localOnly: true,
        message,
        package: packageName,
      },
    });

    expect(mockWithScope).not.toHaveBeenCalled();
    expect(mockAddBreadcrumb).not.toHaveBeenCalled();
  });
});
