import {
  Severity,
  captureException,
  captureMessage,
  withScope,
} from '@sentry/browser';
import type { ErrorLogPayload } from '../types';

export function recordError({
  category,
  context,
  error,
  level,
  localOnly,
  message,
  package: packageName,
}: ErrorLogPayload): void {
  if (!localOnly) {
    withScope((scope) => {
      scope.setTag('package', packageName);
      scope.setTag('category', category);

      if (context) {
        scope.setContext('context', context);
      }

      if (level) {
        scope.setLevel(Severity.fromString(level));
      }

      if (error) {
        scope.setTag('message', message);
        captureException(error);
      } else {
        captureMessage(message);
      }
    });
  }
}
