import type { Primitive } from 'type-fest';

/**
 * Levels corresponding to values in Sentry's Severity enum and which match
 * values in cloudwatch metric filters
 */
export type ErrorLevel = 'error' | 'fatal';

export interface LogPayload {
  /**
   * Additional sub-grouping information beyond package.
   */
  category: string;
  /**
   * Primitive-value object for adding additional data to a log.
   */
  context?: Record<string, Primitive> | undefined;
  /**
   * Prevents log entry from being recorded in Sentry and only sent to the
   * local console.
   */
  localOnly?: true;
  /**
   * Main information for log entry, should be appropriately aggregatable for
   * sorting in Sentry, etc.
   */
  message: string;
  /**
   * Name of the library or application in which the log entry originates.
   */
  package: string;
}

export interface ErrorLogPayload extends LogPayload {
  /**
   * A raw error object. Without this, the message text is used as the error.
   */
  error?: Error | null | undefined;
  /**
   * The severity of the error. If not supplied, will default to 'error'.
   */
  level?: ErrorLevel;
}
