# Tachyon-More-UI

More Than [Core-UI](https://git.xarth.tv/core-ui/core-ui) ™.

More-UI offers some useful enhanced Core UI components and utility methods for
working with Core UI.

## Documentation and Examples

- [Docs: Core-UI](http://design.xarth.tv/user-interface/getting-started)
- [Example: Tomorrow](../../../apps/tomorrow)
- [Example: Sky Map](../../../apps/sky-map)

## Consuming MORE-UI In Tachyon Apps

1. In the application's `package.json` `dependencies` list add:

```json
"dependencies": {
  "react-router-dom": "<current version>",
  "tachyon-noop": "<current version>",
},
```

1. In the application's `package.json` `browser` list add:

```json
"browser": {
  "react-router": false,
  "react-router-dom": false,
}
```

1. In `next.config.js`, no-op `react-router` from being bundled on the client:

```ts
// set up aliases
const alias = config.resolve.alias || {};

// react-router isn't used by Tachyon apps but is required by core-ui;
// only necessary because of unused transient dependencies related to
// latency components that aren't tree-shaken on the server
config.resolve.alias = {
  ...alias,
  'react-router': 'tachyon-noop',
  'react-router-dom': 'tachyon-noop',
};
```

1.

## MORE-UI Features

### Mixins for styled-components

There are several mixins exported to enable re-usable functionality within
styled-components style strings:

- squareSize: sets equal height and width based on sizePct, sizePx, or sizeRem
- backgroundMatchedGradientDark: a top-to-bottom linear gradient that blends
  into dark `color-background-body`

### Responsively Optimized Images

MORE-UI includes utility functions that simplify the configuration required to
optimize image downloads using image template strings. This includes support
for: Avatars, Box Art, Offline Overlays, Channel Banners, and Event Banners.

```ts
import {
  getBoxArtSrcAndSrcSet,
  getChannelThumbnailSrcAndSrcSet,
  getChannelBannerImageTemplate,
  getOverlaySrcAndSrcSet,
} from 'tachyon-more-ui';
```

Example:

```ts
import type { FC } from 'react';
import { CoreImage, getBoxArtSrcAndSrcSet } from 'tachyon-more-ui';

/**
 * imageTemplate is a string containing a "{width}" and "{height}" placeholder.
 * The utility function will automatically replace those
 */
export const BoxArtImage: FC<BoxArtImageProps> = ({ imageTemplate }) => {
  const srcProps = getBoxArtSrcAndSrcSet(imageTemplate);
  return <CoreImage {...srcProps} />;
};
```

## Style Considerations

Prefer using `rem` over `px` or other sizing units. This allows consumers to set
the root font-size to achieve scaling across device sizes -- like TVs and
phones.

## QR Code Sizing

### Sizing Rules

Commonly recommended viewing distance from your TV is to have it 1.5-2.5x
further away from your couch than the diagonal length of the screen for 1080p
and 1-1.5x for
4k[1](https://www.bhphotovideo.com/explora/home-entertainment/tips-and-solutions/sitting-too-close-your-tv%3F-why-distance-matters)[2](https://www.avu.ca/video/perfecting-proximity-finding-optimal-tv-viewing-distance/)[3](https://www.crutchfield.com/S-mZr3VwN1Dn4/learn/learningcenter/home/TV_placement.html).

The recommended size of a QR code is based on the expected distance from the
code and the reader. The advice was universally that once you exceed the minimum
size then the width of the code should be 1/10 the distance. So, if you expect a
person to be on their couch 5' away then the QR code should be 6" wide.

Therefore:

QR Code Width = TV diagonal \* expected viewing distance multiplier / 10 Via
16:9 aspect ratio, TV width = 1.15 \* TV diagonal

Combining the above:

11.5vw \* viewing distance multiplier = QR code width

### Recommended Sizes

- 1.5x viewing distance: 17.3vw (or 17.3% of screen)
- 2.0x viewing distance: 23vw
- 2.5x viewing distance: 28.8vw
