import type { FC } from 'react';
import styled from 'styled-components';
import type { AvatarProps as CoreAvatarProps } from 'twitch-core-ui';
import { Avatar as CoreAvatar } from 'twitch-core-ui';
import type { SquareSizeProps, WithSquareSizeProps } from '../sc-mixins';
import { squareSize } from '../sc-mixins';

// The avatar color is calculated from the sum of character codes. This produces
// a dark purple.
const USER_LOGIN_FALLBACK = 'P';

// istanbul ignore next: trivial
const ScAvatar = styled.div<SquareSizeProps>`
  & figure {
    ${squareSize}
  }
`;

export type AvatarProps = WithSquareSizeProps<Omit<CoreAvatarProps, 'size'>>;

export const Avatar: FC<AvatarProps> = ({ userLogin, ...props }) => {
  // https://jira.twitch.com/browse/COREUI-2967
  const login = userLogin ?? USER_LOGIN_FALLBACK;

  return (
    <ScAvatar {...(props as SquareSizeProps)}>
      <CoreAvatar {...props} size={300} userLogin={login} />
    </ScAvatar>
  );
};

Avatar.displayName = 'Avatar';
