import type { FC, ReactNode } from 'react';
import { useEffect, useState } from 'react';

export type ClientOnlyProps = {
  ssrPlaceholder?: ReactNode;
};

export type ClientOnlyState = {
  canRender: boolean;
};

/**
 * A component for preventing server-side rendering of a React subtree.
 * It takes an optional `ssrPlaceholder` prop that can be any React Node
 * to be rendered in place of the subtree on the server (e.g. spinners,
 * placeholders, etc). If none is provided, it will render a null on the server.
 */
// istanbul ignore next: trivial
export const ClientOnly: FC<ClientOnlyProps> = ({
  children,
  ssrPlaceholder = null,
}) => {
  const [canRender, setCanRender] = useState(false);

  useEffect(() => {
    setCanRender(true);
  }, []);

  return <>{canRender ? children : ssrPlaceholder}</>;
};

ClientOnly.displayName = 'ClientOnly';
