// eslint-disable-next-line import/no-internal-modules
import fonts from 'twitch-core-ui-fonts/fonts/fonts.json';

// We use font-display: fallback because Chrome is getting aggressive about
// discarding optional fonts, differing from the technical definition of the
// font-display options.

/**
 * This function is used to dynamically consume the font info data structure`
 * from twitch-core-ui-fonts. We can't use this function directly inside of
 * components because dynamic `require` statements defeat webpack. Instead we
 * use this to generate a snapshot that we can copy into runtime code (with a
 * few alterations), while also being alerted anytime the underlying data
 * structure changes. The generated snapshot needs the following changes:
 * - left align the contents
 * - replace `\${` with `${`
 * - saving after this will trigger prettier
 */
export function generateFontHtml(): string {
  return Object.values(fonts)
    .map(({ family, unicodeRange, variants }) =>
      Object.entries(variants)
        .map(([weight, weightData]) =>
          Object.entries(weightData)
            .map(([style, styleData]) =>
              Object.entries(styleData)
                .map(([language, { url }]) => {
                  const sources = Object.entries(url)
                    .map(
                      ([format, source]) =>
                        `url('\${require('${source}').default}') format('${format}')`,
                    )
                    .join(', ');

                  const unicodeRangeForLanguage = (
                    unicodeRange as Record<string, string | undefined>
                  )[language];

                  return unicodeRangeForLanguage
                    ? `
@font-face {
  font-display: fallback;
  font-family: '${family}';
  font-style: ${style};
  font-weight: ${weight};
  src: ${sources};
  unicode-range: ${unicodeRangeForLanguage};
}`
                    : `
@font-face {
  font-display: fallback;
  font-family: '${family}';
  font-style: ${style};
  font-weight: ${weight};
  src: ${sources};
}`;
                })
                .join(''),
            )
            .join(''),
        )
        .join(''),
    )
    .join('')
    .trim();
}
