import { generateFontHtml } from '.';

describe(generateFontHtml, () => {
  it('generates font data', () => {
    // Whenever this snapshot changes, update the twitch-core-ui-fonts version
    // in the `generateFontHtml` jsdocs and all associated app usages
    // eslint-disable-next-line jest/no-large-snapshots
    expect(generateFontHtml()).toMatchInlineSnapshot(`
      "@font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 400;
        src: url('\${require('@fontsource/inter/files/inter-cyrillic-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-cyrillic-400-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-cyrillic-400-normal.woff').default}') format('woff');
        unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 400;
        src: url('\${require('@fontsource/inter/files/inter-cyrillic-ext-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-cyrillic-ext-400-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-cyrillic-ext-400-normal.woff').default}') format('woff');
        unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 400;
        src: url('\${require('@fontsource/inter/files/inter-greek-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-greek-400-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-greek-400-normal.woff').default}') format('woff');
        unicode-range: U+0370-03FF;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 400;
        src: url('\${require('@fontsource/inter/files/inter-greek-ext-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-greek-ext-400-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-greek-ext-400-normal.woff').default}') format('woff');
        unicode-range: U+1F00-1FFF;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 400;
        src: url('\${require('@fontsource/inter/files/inter-latin-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-latin-400-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-latin-400-normal.woff').default}') format('woff');
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 400;
        src: url('\${require('@fontsource/inter/files/inter-latin-ext-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-latin-ext-400-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-latin-ext-400-normal.woff').default}') format('woff');
        unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 400;
        src: url('\${require('@fontsource/inter/files/inter-vietnamese-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-vietnamese-400-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-vietnamese-400-normal.woff').default}') format('woff');
        unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+1EA0-1EF9, U+20AB;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 600;
        src: url('\${require('@fontsource/inter/files/inter-cyrillic-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-cyrillic-600-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-cyrillic-600-normal.woff').default}') format('woff');
        unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 600;
        src: url('\${require('@fontsource/inter/files/inter-cyrillic-ext-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-cyrillic-ext-600-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-cyrillic-ext-600-normal.woff').default}') format('woff');
        unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 600;
        src: url('\${require('@fontsource/inter/files/inter-greek-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-greek-600-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-greek-600-normal.woff').default}') format('woff');
        unicode-range: U+0370-03FF;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 600;
        src: url('\${require('@fontsource/inter/files/inter-greek-ext-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-greek-ext-600-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-greek-ext-600-normal.woff').default}') format('woff');
        unicode-range: U+1F00-1FFF;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 600;
        src: url('\${require('@fontsource/inter/files/inter-latin-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-latin-600-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-latin-600-normal.woff').default}') format('woff');
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 600;
        src: url('\${require('@fontsource/inter/files/inter-latin-ext-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-latin-ext-600-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-latin-ext-600-normal.woff').default}') format('woff');
        unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 600;
        src: url('\${require('@fontsource/inter/files/inter-vietnamese-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-vietnamese-600-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-vietnamese-600-normal.woff').default}') format('woff');
        unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+1EA0-1EF9, U+20AB;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 700;
        src: url('\${require('@fontsource/inter/files/inter-cyrillic-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-cyrillic-700-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-cyrillic-700-normal.woff').default}') format('woff');
        unicode-range: U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 700;
        src: url('\${require('@fontsource/inter/files/inter-cyrillic-ext-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-cyrillic-ext-700-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-cyrillic-ext-700-normal.woff').default}') format('woff');
        unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 700;
        src: url('\${require('@fontsource/inter/files/inter-greek-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-greek-700-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-greek-700-normal.woff').default}') format('woff');
        unicode-range: U+0370-03FF;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 700;
        src: url('\${require('@fontsource/inter/files/inter-greek-ext-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-greek-ext-700-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-greek-ext-700-normal.woff').default}') format('woff');
        unicode-range: U+1F00-1FFF;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 700;
        src: url('\${require('@fontsource/inter/files/inter-latin-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-latin-700-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-latin-700-normal.woff').default}') format('woff');
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 700;
        src: url('\${require('@fontsource/inter/files/inter-latin-ext-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-latin-ext-700-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-latin-ext-700-normal.woff').default}') format('woff');
        unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 700;
        src: url('\${require('@fontsource/inter/files/inter-vietnamese-variable-wghtOnly-normal.woff2').default}') format('woff2-variations'), url('\${require('@fontsource/inter/files/inter-vietnamese-700-normal.woff2').default}') format('woff2'), url('\${require('@fontsource/inter/files/inter-vietnamese-700-normal.woff').default}') format('woff');
        unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+1EA0-1EF9, U+20AB;
      }
      @font-face {
        font-display: fallback;
        font-family: 'Roobert';
        font-style: normal;
        font-weight: 400;
        src: url('\${require('twitch-core-ui-fonts/fonts/web/roobert/Roobert-Regular.woff2').default}') format('woff2'), url('\${require('twitch-core-ui-fonts/fonts/web/roobert/Roobert-Regular.woff').default}') format('woff');
      }
      @font-face {
        font-display: fallback;
        font-family: 'Roobert';
        font-style: normal;
        font-weight: 600;
        src: url('\${require('twitch-core-ui-fonts/fonts/web/roobert/Roobert-SemiBold.woff2').default}') format('woff2'), url('\${require('twitch-core-ui-fonts/fonts/web/roobert/Roobert-SemiBold.woff').default}') format('woff');
      }
      @font-face {
        font-display: fallback;
        font-family: 'Roobert';
        font-style: normal;
        font-weight: 700;
        src: url('\${require('twitch-core-ui-fonts/fonts/web/roobert/Roobert-Bold.woff2').default}') format('woff2'), url('\${require('twitch-core-ui-fonts/fonts/web/roobert/Roobert-Bold.woff').default}') format('woff');
      }"
    `);
  });
});
