import type { FC } from 'react';
import type { CSSObject } from 'styled-components';
import styled from 'styled-components';
import type { SVGProps } from 'twitch-core-ui';
import { SVG } from 'twitch-core-ui';
import { squareSize } from '../sc-mixins';

// Core UI uses 20px and assumes a base font-size of 10px
export const DEFAULT_SVG_SIZE_REM = 2;

export interface SizeProps {
  fillParent?: boolean | undefined;
  /**
   * Height in rem units. Defaults to 2.
   */
  heightRem?: number;
  /**
   * Width in rem units. Defaults to 2.
   */
  widthRem?: number;
}

export function getContainerSize({
  fillParent,
  heightRem,
  widthRem,
}: SizeProps): CSSObject {
  if (fillParent) {
    return squareSize({ sizePct: 100 });
  }

  return {
    height: `${heightRem}rem`,
    width: `${widthRem}rem`,
  };
}

export const ScContainer = styled.div<SizeProps>`
  ${getContainerSize}
`;

interface RemSVGProps extends Omit<SVGProps, 'height' | 'width'>, SizeProps {}

export const RemSVG: FC<RemSVGProps> = ({
  fill,
  heightRem = DEFAULT_SVG_SIZE_REM,
  widthRem = DEFAULT_SVG_SIZE_REM,
  ...svgProps
}) => {
  return (
    <ScContainer fillParent={fill} heightRem={heightRem} widthRem={widthRem}>
      <SVG fill {...svgProps} />
    </ScContainer>
  );
};

RemSVG.displayName = 'RemSVG';
