import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { SVGAsset } from 'twitch-core-ui';
import { DEFAULT_SVG_SIZE_REM } from '../RemSVG';
import { ScContainer, ShadowedSVG } from '.';

describe(ShadowedSVG, () => {
  const setup = createShallowWrapperFactory(ShadowedSVG, () => ({
    asset: SVGAsset.DeadGlitch,
  }));

  describe('container size', () => {
    it('renders to default size without any size props', () => {
      const { wrapper } = setup();
      const container = wrapper.find(ScContainer);

      expect(container).toHaveStyleRule('height', `${DEFAULT_SVG_SIZE_REM}rem`);
      expect(container).toHaveStyleRule('width', `${DEFAULT_SVG_SIZE_REM}rem`);
    });

    it('renders to specific height and width', () => {
      const heightRem = 12;
      const widthRem = 34;
      const { wrapper } = setup({ heightRem, widthRem });
      const container = wrapper.find(ScContainer);

      expect(container).toHaveStyleRule('height', `${heightRem}rem`);
      expect(container).toHaveStyleRule('width', `${widthRem}rem`);
    });

    it('renders to 100% size with fill prop', () => {
      const { wrapper } = setup({ fill: true });
      const container = wrapper.find(ScContainer);

      expect(container).toHaveStyleRule('height', '100%');
      expect(container).toHaveStyleRule('width', '100%');
    });
  });
});
