import { isValidHex } from 'tachyon-utils-stdlib';
import { StaticTokenMap } from 'twitch-core-ui-tokens';

export function getStreamAccentColor(
  hexColor: string | null | undefined,
): string {
  const prependedHexString =
    hexColor && !hexColor.startsWith('#') ? `#${hexColor}` : hexColor;
  return prependedHexString && isValidHex(prependedHexString)
    ? prependedHexString
    : StaticTokenMap['color-accent'];
}
