import { StaticTokenMap } from 'twitch-core-ui-tokens';
import { getStreamAccentColor } from '.';

describe(getStreamAccentColor, () => {
  it('returns the default color when an invalid hex is provided', () => {
    const color = getStreamAccentColor('zzz');
    expect(color).toEqual(StaticTokenMap['color-accent']);
  });

  it('returns the default color when no color is provided', () => {
    const color = getStreamAccentColor(null);
    expect(color).toEqual(StaticTokenMap['color-accent']);
  });
  it('returns the passed in color when a valid hex is provided', () => {
    const passedColor = '#fff';
    expect(getStreamAccentColor(passedColor)).toEqual(passedColor);
  });

  it('prepends a hash when one is not provided', () => {
    const passedColor = 'fff';
    expect(getStreamAccentColor(passedColor)).toEqual(`#${passedColor}`);
  });
});
