import type { FC } from 'react';
import type { FormatMessage } from 'tachyon-intl';
import type { CoreLinkProps } from 'twitch-core-ui';
import { CoreLink, Display, Layout } from 'twitch-core-ui';

/**
 * Href values to be used by consumers to construct their links
 */
export enum TwitchEntityInformationLink {
  BusinessInfo = 'http://www.ftc.go.kr/bizCommPop.do?wrkr_no=4568600890&apv_perm_no',
  Help = 'https://help.twitch.tv',
  TermsOfSale = 'https://www.twitch.tv/p/legal/terms-of-sale',
}

type RouteProps = Omit<CoreLinkProps, 'linkTo'>;

export type TwitchEntityInformationLinkRoutes = {
  businessInfo: RouteProps;
  /**
   * Optional so that it can be removed on clients that
   * don't have good link support, e.g. TV
   */
  help?: RouteProps;
  termsOfSale: RouteProps;
};

export type TwitchEntityInformationLinksProps = {
  formatMessage: FormatMessage;
  /**
   * Rendered components that link to the proper help pages
   */
  linkProps: TwitchEntityInformationLinkRoutes;
};

export const TwitchEntityInformationLinks: FC<TwitchEntityInformationLinksProps> =
  ({ formatMessage, linkProps: { businessInfo, help, termsOfSale } }) => (
    <>
      {help && (
        <Layout
          borderRight
          display={Display.Inline}
          margin={{ right: 0.5 }}
          padding={{ right: 0.5 }}
        >
          <CoreLink linkTo="/deferToRenderLink" {...help}>
            {formatMessage('Contact Support', 'EntityInformationModalLink')}
          </CoreLink>
        </Layout>
      )}
      <Layout
        borderRight
        display={Display.Inline}
        margin={{ right: 0.5 }}
        padding={{ right: 0.5 }}
      >
        <CoreLink linkTo="/deferToRenderLink" {...termsOfSale}>
          {formatMessage('Terms of Sale', 'EntityInformationModalLink')}
        </CoreLink>
      </Layout>
      <Layout display={Display.Inline}>
        <CoreLink linkTo="/deferToRenderLink" {...businessInfo}>
          {formatMessage('Business Info', 'EntityInformationModalLink')}
        </CoreLink>
      </Layout>
    </>
  );

TwitchEntityInformationLinks.displayName = 'TwitchEntityInformationLinks';
