import type { FC } from 'react';
import type { FormatMessage } from 'tachyon-intl';
import {
  Layout,
  Modal,
  ModalBody,
  ModalFooter,
  ModalHeader,
  ModalSize,
} from 'twitch-core-ui';
import type { TwitchEntityInformationLinkRoutes } from '../TwitchEntityInformationLinks';
import { TwitchEntityInformationLinks } from '../TwitchEntityInformationLinks';
import { getEntityInformation } from '../utils';

type TwitchEntityInformationModalProps = {
  formatMessage: FormatMessage;
  linkProps: TwitchEntityInformationLinkRoutes;
  onToggleModal: () => void;
  show: boolean;
};

// istanbul ignore next: trivial
// Default modal, already composed and opinionated
export const TwitchEntityInformationModal: FC<TwitchEntityInformationModalProps> =
  ({ formatMessage, linkProps, onToggleModal, show }) => {
    const { address, hosting, phone, representative, tradename } =
      getEntityInformation(formatMessage);

    return (
      <Modal onRequestClose={onToggleModal} show={show} size={ModalSize.Large}>
        <ModalHeader
          closeButton={{
            'aria-label': formatMessage(
              'Close Modal',
              'EntityInformationModal',
            ),
            onClick: onToggleModal,
          }}
          title={formatMessage('Entity Information', 'EntityInformationModal')}
        />
        <ModalBody>
          <Layout padding={2}>
            <p>{tradename}</p>
            <p>{representative}</p>
            <p>{address}</p>
            <p>{phone}</p>
            <p>{hosting}</p>
            <Layout margin={{ top: 1 }}>
              <TwitchEntityInformationLinks
                formatMessage={formatMessage}
                linkProps={linkProps}
              />
            </Layout>
          </Layout>
        </ModalBody>
        <ModalFooter
          primaryButtonProps={{
            children: formatMessage('Close', 'EntityInformationModal'),
            onClick: onToggleModal,
          }}
        />
      </Modal>
    );
  };

TwitchEntityInformationModal.displayName = 'TwitchEntityInformationModal';
