import type { FormatMessage } from 'tachyon-intl';

export interface EntityInformation {
  address: string;
  hosting: string;
  phone: string;
  representative: string;
  tradename: string;
}

export function getEntityInformation(
  formatMessage: FormatMessage,
): EntityInformation {
  return {
    address: formatMessage(
      'Address: 350 Bush Street, Suite 200, San Francisco, California, 94104, USA',
      'EntityInformationModal',
    ),
    hosting: formatMessage(
      'Hosting Provider: Amazon Web Services, Inc.',
      'EntityInformationModal',
    ),
    phone: formatMessage(
      'Phone Number: 070-8984-5697',
      'EntityInformationModal',
    ),
    representative: formatMessage(
      'Representative: Emmett Shear, CEO',
      'EntityInformationModal',
    ),
    tradename: formatMessage(
      'Tradename: Twitch Interactive, Inc.',
      'EntityInformationModal',
    ),
  };
}
