import type { BaseQRCodeProps } from 'qrcode.react';
import QRCodeReact from 'qrcode.react';
import type { FC } from 'react';
import styled from 'styled-components';
import { Layout } from 'twitch-core-ui';
import { DarkThemeMap } from 'twitch-core-ui-tokens';
import type { SquareSizeProps, WithSquareSizeProps } from '../../sc-mixins';
import { squareSize } from '../../sc-mixins';

const qrBackgroundColor = DarkThemeMap['color-text-base'];

const ScQRCodeBox = styled(Layout)<SquareSizeProps>`
  background-color: ${qrBackgroundColor};
  flex-shrink: 0;
  ${squareSize}
`;

export type QRCodeProps = WithSquareSizeProps<Pick<BaseQRCodeProps, 'value'>>;

// istanbul ignore next: trivial
export const QRCode: FC<QRCodeProps> = ({ value, ...props }) => (
  <ScQRCodeBox {...props} padding={2}>
    <QRCodeReact
      bgColor={qrBackgroundColor}
      fgColor={DarkThemeMap['color-background-float']}
      height="100%"
      level="L"
      renderAs="svg"
      value={value}
      width="100%"
    />
  </ScQRCodeBox>
);

QRCode.displayName = 'QRCode';
