import type { FC } from 'react';
import type { QRCodeProps } from '../QRCode';
import { QRCode } from '../QRCode';

export type QRUrlProps = Omit<QRCodeProps, 'value'> & {
  /**
   * The specific site or feature using this QR code.
   */
  content: string;
  /**
   * The greater context (usually app) for using this QR code.
   */
  medium: string;
  /**
   * The target url for the QR code.
   */
  url: string;
};

/**
 * Encodes a URL into a QRCode. Requires a valid url along with content and
 * medium for tracking attribution. This component requires that the URL api
 * is available and will throw otherwise.
 */
export const QRUrl: FC<QRUrlProps> = ({ content, medium, url, ...props }) => {
  const urlValue = new URL(url);
  urlValue.searchParams.append('tt_content', content);
  urlValue.searchParams.append('tt_medium', medium);

  return (
    <QRCode
      {
        ...(props as any) /* TS has trouble forwarding the RequireExactlyOne functionality */
      }
      value={urlValue.toString()}
    />
  );
};

QRUrl.displayName = 'QRUrl';
