import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { QRCode } from '../QRCode';
import { QRUrl } from '.';

describe(QRUrl, () => {
  const setup = createShallowWrapperFactory(QRUrl, () => ({
    content: 'content',
    inverted: true,
    medium: 'medium',
    url: 'https://twitch.tv',
  }));

  it('builds a URL', () => {
    const { wrapper } = setup();
    expect(wrapper.find(QRCode)).toHaveProp({
      value: 'https://twitch.tv/?tt_content=content&tt_medium=medium',
    });
  });

  it('does not clobber existing params on a URL', () => {
    const { wrapper } = setup({ url: 'https://twitch.tv/?query=param' });
    expect(wrapper.find(QRCode)).toHaveProp({
      value:
        'https://twitch.tv/?query=param&tt_content=content&tt_medium=medium',
    });
  });
});
