import { transparentize } from 'polished';
import type { CSSObject } from 'styled-components';
import { DarkThemeMap } from 'twitch-core-ui-tokens';

type BackgroundMatchedGradientDarkOpts = {
  /**
   * Transition percentage stop value from 0 (transition begins immediately) to
   * 100 (transition does not start/transparent across entire element). Defaults
   * to 0.
   */
  startPct?: number;
  /**
   * Transition percentage stop value from 0 (immediately full color) to 100
   * (transitions evenly across the full height of the element). Defaults to
   * 100.
   */
  stopPct?: number;
  /**
   * Controls the direction of the transition. Defaults to 'bottom'.
   */
  to?: 'bottom' | 'left' | 'right' | 'top';
};

const defaultOpts: BackgroundMatchedGradientDarkOpts = {
  startPct: 0,
  stopPct: 100,
  to: 'bottom',
};

/**
 * Generates a CSS linear-gradient rule for background-image that transitions
 * from transparent to the full dark `color-background-body`.
 */
export function backgroundMatchedGradientDark({
  startPct = defaultOpts.startPct,
  stopPct = defaultOpts.stopPct,
  to = defaultOpts.to,
}: BackgroundMatchedGradientDarkOpts = defaultOpts): CSSObject {
  return {
    backgroundImage: `linear-gradient(to ${to}, ${transparentize(
      1,
      DarkThemeMap['color-background-body'],
    )} ${startPct}%, ${DarkThemeMap['color-background-body']} ${stopPct}%)`,
  };
}
