import { backgroundMatchedGradientDark } from '.';

describe(backgroundMatchedGradientDark, () => {
  it('generates a proper gradient with only defaults', () => {
    expect(backgroundMatchedGradientDark()).toEqual({
      backgroundImage:
        'linear-gradient(to bottom, rgba(14,14,16,0) 0%, #0e0e10 100%)',
    });
  });

  it('generates a proper gradient with all optional args', () => {
    expect(
      backgroundMatchedGradientDark({ startPct: 14, stopPct: 53, to: 'right' }),
    ).toEqual({
      backgroundImage:
        'linear-gradient(to right, rgba(14,14,16,0) 14%, #0e0e10 53%)',
    });
  });
});
