import {
  horizontalOverflowIntoSafeArea,
  safeAreaPaddingInVw,
  safeAreaWidthInVw,
} from '.';

describe('safe area utils', () => {
  it('generates widths', () => {
    expect(safeAreaWidthInVw({ vw: 20 })).toEqual({
      width:
        '20vw; width: calc((100vw - env(safe-area-inset-left) - env(safe-area-inset-right)) * 0.2 )',
    });
  });

  it('generates paddings', () => {
    expect(safeAreaPaddingInVw({ vw: 20 })).toEqual({
      padding:
        '20vw; padding: calc((100vw - env(safe-area-inset-left) - env(safe-area-inset-right)) * 0.2 )',
    });
  });

  it('generates overflows', () => {
    expect(horizontalOverflowIntoSafeArea({ buffer: '2rem' })).toEqual({
      'margin-left': 'calc(-1 * (env(safe-area-inset-left) + 2rem))',
      'margin-right': 'calc(-1 * (env(safe-area-inset-right) + 2rem))',
      'overflow-x': 'scroll',
      'padding-left': 'calc(env(safe-area-inset-left) + 2rem)',
      'padding-right': 'calc(env(safe-area-inset-right) + 2rem)',
    });
  });
});
