import type { CSSObject } from 'styled-components';
import type { RequireExactlyOne } from 'type-fest';

type BaseSquareSizeProps = {
  sizePct: number;
  sizePx: number;
  sizeRem: number;
};

export type WithSquareSizeProps<T> = RequireExactlyOne<
  BaseSquareSizeProps & T,
  keyof BaseSquareSizeProps
>;

export type SquareSizeProps = WithSquareSizeProps<{}>;

/**
 * Generates equal height and width css properties. Returns empty object
 * in the case where you somehow defeat TypeScript.
 */
export function squareSize({
  sizePct,
  sizePx,
  sizeRem,
}: SquareSizeProps): CSSObject {
  // in order of common usage
  const size =
    sizeRem !== undefined
      ? `${sizeRem}rem`
      : sizePx !== undefined
      ? `${sizePx}px`
      : sizePct !== undefined
      ? `${sizePct}%`
      : undefined;

  return size ? { height: size, width: size } : {};
}
