import { squareSize } from '.';

describe(squareSize, () => {
  it('works for rem', () => {
    expect(squareSize({ sizeRem: 5 })).toEqual({
      height: '5rem',
      width: '5rem',
    });
  });

  it('allows rem 0', () => {
    expect(squareSize({ sizeRem: 0 })).toEqual({
      height: '0rem',
      width: '0rem',
    });
  });

  it('works for px', () => {
    expect(squareSize({ sizePx: 30 })).toEqual({
      height: '30px',
      width: '30px',
    });
  });

  it('allows px 0', () => {
    expect(squareSize({ sizePx: 0 })).toEqual({
      height: '0px',
      width: '0px',
    });
  });

  it('works for pct', () => {
    expect(squareSize({ sizePct: 50 })).toEqual({
      height: '50%',
      width: '50%',
    });
  });

  it('allows pct 0', () => {
    expect(squareSize({ sizePct: 0 })).toEqual({
      height: '0%',
      width: '0%',
    });
  });

  it('returns empty string as fallback', () => {
    // @ts-expect-error: Testing the case where someone omits all required args
    expect(squareSize({})).toEqual({});
  });
});
