import { createMountWrapperFactory } from 'tachyon-test-utils';
import {
  ChannelStatusIndicator,
  ChannelStatusIndicatorStatus,
  ChannelStatusTextIndicator,
  CoreText,
  Layout,
  SVG,
  SVGAsset,
} from 'twitch-core-ui';
import { StreamType } from '../utils';
import { StreamTypeIndicator } from '.';

describe(StreamTypeIndicator, () => {
  const setup = createMountWrapperFactory(StreamTypeIndicator, () => ({
    isOverlay: false,
    isPulsing: false,
    streamType: StreamType.Live,
  }));

  it('renders only layout placeholders when no indicator type is provided', () => {
    const { wrapper } = setup({ streamType: undefined });

    expect(wrapper.children().is(Layout)).toBeTruthy();
    expect(wrapper.find(ChannelStatusIndicator)).not.toExist();
    expect(wrapper.find(ChannelStatusTextIndicator)).not.toExist();
    expect(wrapper.find(CoreText)).not.toExist();
  });

  it('renders a text-only status for live', () => {
    const { wrapper } = setup({ streamType: StreamType.Live });
    expect(wrapper.find(SVG)).not.toExist();
    expect(wrapper.find(ChannelStatusTextIndicator)).toHaveProp({
      label: 'LIVE',
    });
  });

  it('renders a hosting status', () => {
    const { wrapper } = setup({ streamType: StreamType.Hosting });

    expect(wrapper.find(ChannelStatusIndicator)).toHaveProp({
      status: ChannelStatusIndicatorStatus.Hosting,
    });
    expect(wrapper.find(SVG)).not.toExist();
    expect(wrapper.find(CoreText).children().text()).toBe('HOSTING');
  });

  it('renders a premiere status', () => {
    const { wrapper } = setup({ streamType: StreamType.Premiere });
    expect(wrapper.find(SVG)).toHaveProp({ asset: SVGAsset.VideoPremiere });
    expect(wrapper.find(CoreText).children().text()).toBe('Premiere');
  });

  it('renders a re-run status', () => {
    const { wrapper } = setup({ streamType: StreamType.Rerun });
    expect(wrapper.find(SVG)).toHaveProp({ asset: SVGAsset.VideoRerun });
    expect(wrapper.find(CoreText).children().text()).toBe('Rerun');
  });
});
