import { isValidObject } from 'tachyon-relay';

export enum StreamType {
  Hosting = 'hosting',
  Live = 'live',
  Premiere = 'premiere',
  Rerun = 'rerun',
}

type Stream = {
  broadcaster: {
    hosting: {
      id: string;
    } | null;
  } | null;
  type: string | null;
};

function hosting(stream: Stream): boolean {
  return isValidObject(stream.broadcaster?.hosting);
}

export function getStreamType(stream: Stream): StreamType | undefined {
  if (hosting(stream)) {
    return StreamType.Hosting;
  }

  switch (stream.type) {
    case 'live':
      return StreamType.Live;
    case 'premiere':
      return StreamType.Premiere;
    case 'watch_party':
    case 'rerun':
      return StreamType.Rerun;
    default:
      return;
  }
}
