import { validId } from 'tachyon-relay';
import { StreamType, getStreamType } from '.';

const mockStream = {
  broadcaster: {
    hosting: null,
  },
  type: 'live',
};

describe('streamType detects', () => {
  it('hosting', () => {
    const status = getStreamType({
      ...mockStream,
      broadcaster: { hosting: { id: validId() } },
    });

    expect(status).toEqual(StreamType.Hosting);
  });

  it('live', () => {
    const status = getStreamType({ ...mockStream, type: 'live' });

    expect(status).toEqual(StreamType.Live);
  });

  it('premiere', () => {
    const status = getStreamType({ ...mockStream, type: 'premiere' });

    expect(status).toEqual(StreamType.Premiere);
  });

  it('watch_party (rerun)', () => {
    const status = getStreamType({ ...mockStream, type: 'watch_party' });

    expect(status).toEqual(StreamType.Rerun);
  });

  it('rerun', () => {
    const status = getStreamType({ ...mockStream, type: 'rerun' });

    expect(status).toEqual(StreamType.Rerun);
  });

  it('unknown', () => {
    const status = getStreamType({ ...mockStream, type: 'newstatus' });

    expect(status).toBeUndefined();
  });
});
