import type { FC } from 'react';

// istanbul ignore next: trivial
export const GlowErrorCarSvg: FC = () => {
  return (
    <svg
      fill="none"
      height="100%"
      preserveAspectRatio="xMidYMid meet"
      role="img"
      viewBox="0 0 556 556"
      width="100%"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M300.342.059c-.911.174-3.25.962-4.427 1.491l-1.201.506c-.386 0-6.129 3.569-6.514 4.047-.058.073-.583.463-1.166.867l-2.14 1.588-1.796 1.386-4.292 3.517c-1.313 1.14-9.12 7.516-12.546 10.245l-4.872 3.952c-.19.186-.873.749-1.518 1.249s-1.651 1.322-2.236 1.824l-3.835 3.207-2.875 2.429c-.059.075-1.309 1.139-2.779 2.366l-8.404 7.139-4.26 3.722c-4.332 3.803-6.476 5.382-10.118 7.449l-4.367 2.513-4.047 2.401-10.331 6.28-3.909 2.466c-.049 0-.651.367-1.338.816l-2.314 1.494-3.089 1.989-6.816 4.404-4.58 2.98-3.669 2.418c-.847.57-1.63 1.037-1.74 1.037s-.232.078-.271.174-2.611 1.871-5.716 3.945l-9.266 6.264c-.219.192-2.079 1.495-2.679 1.875-.676.429-3.342 2.287-5.522 3.848l-3.94 2.764-3.137 2.178-5.006 3.509-4.851 3.389-2.224 1.558-4.092 2.901-4.556 3.198c-.776.528-1.523 1.056-1.66 1.173a33.52 33.52 0 0 1-1.207.918l-5.431 3.978c-.762.544-6.972 5.168-9.231 6.874l-2.663 1.975a42.41 42.41 0 0 0-1.553 1.173l-1.598 1.221a28.67 28.67 0 0 0-1.144.886l-12.497 9.987c-4.488 3.533-7.195 6.486-8.671 9.46-1.131 2.278-1.306 2.985-1.443 5.847-.148 3.078.202 4.852 1.454 7.382.697 1.408 1.294 2.227 2.515 3.454 1.854 1.862 2.204 2.169 2.471 2.17.107.001.481.23.83.51l.635.508-.635.542c-.594.508-2.881 2.382-4.575 3.749-5.743 4.633-8.856 7.797-11.45 11.639-1.367 2.025-3.034 5.46-3.034 6.253 0 .634-.653.13-1.399-1.083-1.028-1.669-3.302-3.924-4.718-4.678-4.576-2.438-9.757-1.108-12.197 3.133-.702 1.22-1.275 3.597-1.279 5.312-.004 1.55.459 5.382.955 7.906a85.5 85.5 0 0 1 .534 3.091c.133.88.328 1.887.435 2.239s.333 1.503.502 2.558l1.712 10.34.648 3.731c.296 1.586.635 3.785 1.208 7.837.211 1.49.19 1.788-.211 2.985-.867 2.59-.974 4.661-.687 13.352l.446 10.044c.1 1.114.329 4.376.507 7.249s.428 5.99.554 6.928.364 3.433.528 5.544l1.179 12.791.528 4.691.632 5.33.546 4.903c.123 1.29.358 3.209.522 4.264s.36 2.638.435 3.518.22 1.934.322 2.345.33 1.849.507 3.198l.647 4.583.861 5.65.765 4.904.627 3.944 1.36 8.162c.063.201.306 1.373.54 2.604.861 4.54 1.844 8.381 2.891 11.3.743 2.069 2.83 6.766 3.331 7.494.214.312.389.624.389.695s.512.92 1.138 1.886c1.159 1.79 3.429 4.186 4.892 5.163 1.922 1.284 4.75 2.373 6.746 2.596.647.073 1.368.231 1.602.352s2.645 2.434 5.356 5.141c5.17 5.16 6.662 6.599 10.312 9.944l10.191 9.368 7.241 6.609 2.345 2.132a96.43 96.43 0 0 0 1.826 1.599l1.477 1.287c.128.121.855.73 1.616 1.353s1.481 1.245 1.598 1.383.692.632 1.278 1.098 1.113.902 1.172.968.969.836 2.023 1.711l3.926 3.304c.418.361 2.39 1.984 4.381 3.605l4.109 3.447c.269.274.556.499.639.499s.439.267.791.591 1.405 1.206 2.343 1.958l2.023 1.643c1.653 1.417 5.867 4.731 9.579 7.533l3.645 2.772c.219.176.742.559 1.162.852s1.262.919 1.87 1.389c2.138 1.657 9.787 7.278 14.21 10.444l1.946 1.365c.742.517 1.398.997 1.457 1.067s.526.415 1.04.766l2.662 1.854 8.825 6.058 11.968 7.863c2.767 1.832 10.088 6.408 12.461 7.788l4.9 2.863 9.691 5.541 6.604 3.744c.828.517 20.132 10.019 20.353 10.019.048 0 .88.372 1.849.825 2.838 1.33 4.249 1.947 4.452 1.947.104 0 .595.183 1.092.407 1.172.528 6.164 2.262 7.4 2.57.527.131 1.15.324 1.384.429s1.337.345 2.45.533l3.302.587c1.701.326 11.007.334 12.141.01l2.13-.592a31.42 31.42 0 0 0 2.663-.892c6.38-2.509 10.84-5.974 13.944-10.834 1.093-1.71 1.502-2.143 2.883-3.05.645-.422 1.843-1.302 2.663-1.955s1.874-1.433 2.343-1.736c2.009-1.295 4.121-2.533 4.325-2.533.121 0 .251-.073.29-.163.063-.143.664-.527 3.916-2.502.89-.54 3.462-2.166 4.633-2.928.492-.32 1.038-.65 1.214-.731s.559-.311.852-.508 1.108-.723 1.811-1.168l3.727-2.405c3.263-2.127 4.225-2.731 6.003-3.772 1.244-.729 4.725-2.681 5.713-3.205l2.236-1.211a48.19 48.19 0 0 1 1.598-.85c.293-.144 3.168-1.739 6.39-3.546l7.562-4.235 2.023-1.153c.176-.111.703-.395 1.172-.632s1.188-.632 1.598-.878a71.42 71.42 0 0 1 1.704-.978l1.81-1.026a64.98 64.98 0 0 1 1.811-1.003 1531.31 1531.31 0 0 0 13.632-7.611c.176-.11 1.46-.851 2.854-1.647l7.158-4.108c.175-.103 1.278-.727 2.449-1.386l2.45-1.389a4400.13 4400.13 0 0 1 12.674-7.18c.468-.264 1.379-.756 2.023-1.093s2.226-1.216 3.515-1.953l3.728-2.085c.761-.41 1.528-.858 1.704-.995s.655-.414 1.065-.615 1.081-.574 1.491-.827a58.6 58.6 0 0 1 1.528-.904l4.618-2.629c2.11-1.202 4.076-2.186 4.371-2.186s.66.168.813.373c.273.366 1.225 1.038 2.749 1.94 2.519 1.491 6.348 2.188 9.593 1.748 1.098-.149 2.594-.496 3.326-.77 1.444-.542 3.889-1.907 4.74-2.648 3.927-3.416 6.139-6.504 9.311-13.008 1.423-2.917 1.911-3.959 3.043-6.502l1.82-4.051c.806-1.768 2.345-5.455 3.471-8.315l5.148-12.735c.116-.204.212-.473.212-.597s.191-.623.426-1.109.426-.966.426-1.068.535-1.547 1.189-3.211l5.103-12.833c.401-.953 1.256-3.179 2.006-5.223l.856-2.239c.104-.234.312-.81.461-1.279s.335-.949.412-1.066.31-.741.517-1.386.428-1.262.491-1.372c.103-.178.708-1.845 2.287-6.303l1.36-3.837 1.066-2.878c.109-.235.307-.81.44-1.28a12.87 12.87 0 0 1 .432-1.279c.29-.655 3.402-10.16 3.402-10.391 0-.112.132-.506.294-.876s1.272-3.694 2.469-7.387l2.352-7.142c.219-.528 1.914-5.936 2.673-8.528l.947-3.198 1.96-6.822.819-2.879 2.012-7.248c.157-.528.774-2.974 1.373-5.437l1.31-5.33c.122-.469.396-1.716.61-2.771l1.381-6.609c1.537-7.134 2.227-12.583 2.375-18.762.068-2.814.032-6.119-.08-7.345-.202-2.22.02-4.296.582-5.446.115-.235.351-.954.526-1.599l.753-2.66c.24-.819.436-1.596.436-1.728s-1.078-1.14-2.396-2.24l-3.142-2.67a386.11 386.11 0 0 0-3.83-3.307l-3.424-2.959c-.187-.175-1.33-1.183-2.541-2.238l-2.777-2.452-2.45-2.238c-5.478-4.987-9.546-8.918-18.645-18.013-7.761-7.757-12.119-12.288-18.755-19.497l-2.66-2.878-2.13-2.34c-.458-.517-1.168-1.294-1.578-1.726s-1.369-1.489-2.13-2.348l-1.811-2.016c-.234-.249-1.336-1.494-2.449-2.767l-2.556-2.886-1.208-1.328-8.591-9.645-1.171-1.291c-.235-.248-1.241-1.355-2.237-2.46l-2.023-2.241a337.41 337.41 0 0 1-1.598-1.797l-1.704-1.912c-.176-.191-.693-.774-1.15-1.296l-1.81-2.017-1.917-2.132-4.389-4.896-4.367-4.809-2.13-2.326-2.556-2.77-1.904-2.054-2.663-2.869-6.722-7.252-2.325-2.472-3.408-3.602-5.77-6.058c-7.269-7.645-31.366-31.643-38.63-38.472l-15.989-15.159c-7.885-7.383-14.863-14.439-18.336-18.54-1.422-1.68-1.935-2.161-3.195-3.001-.586-.391-2.189-1.556-3.563-2.589-3.256-2.45-5.968-4.331-7.325-5.083-.964-.534-1.197-.811-2.015-2.396-1.632-3.161-4.358-5.614-7.759-6.979-1.359-.546-1.764-.604-4.579-.656-1.699-.031-3.328-.012-3.621.045z"
        fill="#9146ff"
      />
      <path
        d="M250.835 148.114l2.497-1.542c.071.004.163.013.279.03.597.086 1.415.322 2.345.684a23.25 23.25 0 0 1 2.564 1.191l.935.548.291.197.102.078c.876.779 2.287 1.688 3.494 2.465l.562.363c1.44.934 2.465 1.652 2.951 2.138l.003.008c.028.074.105.28.195.689.148.667.263 1.526.368 2.517l.134 1.362.158 1.598c.097.882.23 1.916.478 2.732.005.028.02.115.03.29.015.242.016.553.005.953l-.036.94-.064 1.881c-.012.999.025 2.222.315 3.351.287 1.121.96 2.646 2.601 3.466 1.871.936 3.697.987 4.802 1.019l.398.013c1.041.047 1.347.154 1.748.556.031.048.205.313.377 1.005.178.718.284 1.604.334 2.525l.017 2.408-.037.749-.013.195-.004.044v.006l-.001.001c-.096 1.122.484 2.194 1.475 2.727l.007.004.017.009.06.032.219.116.786.403 2.585 1.23 3.26 1.301c1.061.36 2.293.703 3.417.765s3.136.615 5.191 1.227l.547.164 2 .578c.298.078.741.187 1.153.224.119.011.296.021.503.01.172-.009.567-.042 1.016-.233.483-.205 1.305-.729 1.63-1.82a2.88 2.88 0 0 0-.189-2.113c-.533-1.066-1.65-1.647-2.77-1.55l-1.657-.482-.62-.186c-1.84-.549-4.56-1.346-6.491-1.454-.338-.019-.983-.157-1.916-.474-.884-.3-1.851-.698-2.771-1.109l-1.74-.816-.039-2.26c-.06-1.108-.195-2.384-.492-3.582-.279-1.123-.792-2.563-1.863-3.635-1.913-1.913-3.99-2.135-5.483-2.203l-.516-.022c-.964-.039-1.517-.061-2.083-.274-.093-.382-.14-.984-.13-1.849l.05-1.476.049-1.26c.021-.814.035-2.019-.278-3.037-.072-.236-.165-.771-.266-1.701l-.142-1.427-.149-1.514-.47-3.147c-.188-.847-.544-2.179-1.414-3.146-1.041-1.156-2.829-2.328-4.174-3.201l-.615-.398-.002-.001-2.761-1.912c-.595-.528-1.506-1.088-2.384-1.565-.938-.509-2.062-1.043-3.211-1.49-1.127-.439-2.392-.839-3.586-1.011-.985-.142-2.817-.275-4.254.876-.517.413-1.168.79-2.061 1.284l-.192.107-2.661 1.626c-1.26.917-1.539 2.682-.622 3.942a2.82 2.82 0 0 0 3.941.622c.603-.438 1.285-.815 2.152-1.295l.116-.064zm30.64 34.702l-1.337 2.485s-.001 0 1.337-2.485zm-28.345-36.244c-.001 0 .008-.002.028-.003-.018.003-.028.004-.028.003zm71.984 34.626c-1.298.016-2.149.233-2.827.726-1.26.917-3.025.638-3.942-.622a2.82 2.82 0 0 1 .623-3.942c2.021-1.47 4.222-1.782 6.077-1.805.918-.011 1.827.049 2.613.103l.067.004 2.112.1c2.029 0 4.035.189 5.881.362l.03.003 5.318.34c3.349 0 7.154.871 10.013 1.524l.159.037c3.503.8 6.831 1.418 10.217 2.046l8.077 1.568c1.519.32 3.157.595 4.873.883l.307.052c1.799.302 3.676.622 5.433 1.012l3.641.762 6.307 1.372c1.151.287 2.28.688 3.231 1.025l.847.296c1.172.399 2.141.659 3.154.715.929.052 2.817.271 4.496.733.809.223 1.815.566 2.649 1.123.756.504 2.287 1.863 1.803 4.043-.244 1.096-.903 2.814-1.452 4.243l-.077.203c-.649 1.692-1.15 3.024-1.293 3.666l-.411 1.898-1.017 4.524a5.99 5.99 0 0 0-.061.362l-.13.904a48.63 48.63 0 0 1-.403 2.482c-.166.85-.403 1.85-.761 2.703-.177.422-.445.959-.857 1.444-.286.335-.739.757-1.372 1.028-.035.081-.073.176-.113.286-.297.823-.561 2.039-.798 3.481-.173 1.057-.315 2.121-.449 3.129l-.002.014v.003l-.136 1.008c-.086.625-.174 1.234-.269 1.749-.078.426-.21 1.09-.462 1.643-.765 1.683-1.612 2.916-2.246 3.837l-.42.62c-.606.921-1.067 1.774-1.361 3.356-.172.925-.177 1.695-.128 2.559l.053.758c.055.725.123 1.623.123 2.516a3.08 3.08 0 0 1-.005.168c.634 1.277 1.423 2.514 2.312 3.828l.7 1.024c.961 1.4 2.013 2.933 2.908 4.544.08.143.347.497.856 1.064l.775.839.629.679c.025.029.062.071.628.348l.048.024c.52.254 1.536.75 2.351 1.799.642.825 1.038 1.803 1.256 2.34l.001.002.035.086.016.039.031.075c.261.621.361.71.387.732 1.129.968 1.861 2.341 2.327 3.268l.493 1.002c.282.582.483.997.723 1.364l1.039 1.576c1.293 1.95 2.692 4.06 3.827 6.103l.134.238c.457.813 1.252 2.226 1.643 3.687.355 1.329.491 3.209-.569 4.855.251.498.604 1.12 1.037 1.855l.337.57 1.368 2.386a15.56 15.56 0 0 1 .713 1.495c.18.449.41 1.109.45 1.825.056 1.014.357 2.329.763 3.294.607 1.441.561 3.134.5 4.215-.027.49-.07.988-.107 1.419l-.024.28c-.044.525-.07.899-.07 1.177 0 2.455-.184 4.922-.358 7.26l-.002.028c-.178 2.384-.345 4.634-.345 6.821 0 1.43.083 2.885.172 4.422l.004.076c.086 1.484.177 3.051.177 4.595 0 1.932-.09 3.893-.177 5.789l-.003.066c-.088 1.941-.173 3.818-.173 5.667 0 4.747.614 9.772 2.393 13.686 2.194 4.827 4.662 10.73 4.662 16.844 0 .748.076 1.492.171 2.405v.002l.032.307c.102.997.214 2.189.145 3.439-.037.674-.108 1.371-.171 1.999l-.023.228-.023.236c-.076.778-.131 1.472-.131 2.142 0 1.191-.079 2.729-.738 4.267-.861 2.008-2.729 2.917-3.871 3.383-.577.234-1.177.434-1.666.596l-.125.042c-.557.185-.955.323-1.273.464a2.822 2.822 0 1 1-2.292-5.157c.607-.27 1.26-.488 1.783-.662l.086-.029c.531-.177.962-.32 1.358-.481.584-.238.788-.401.84-.445.176-.449.254-1.037.254-1.978 0-.957.079-1.878.158-2.69l.021-.22.033-.33c.062-.61.115-1.143.145-1.678.042-.76-.022-1.555-.124-2.55l-.032-.31c-.092-.875-.201-1.919-.201-2.98 0-4.756-1.946-9.646-4.156-14.509-2.263-4.978-2.899-10.936-2.899-16.021 0-1.999.092-4.005.18-5.924.088-1.943.173-3.796.173-5.598 0-1.378-.082-2.805-.171-4.345-.088-1.511-.182-3.129-.182-4.748 0-2.409.182-4.845.355-7.167l.006-.074c.178-2.382.345-4.649.345-6.868 0-.545.046-1.139.089-1.65l.028-.325.093-1.218c.028-.494.032-.903.007-1.234s-.071-.465-.074-.474c-.641-1.523-1.082-3.413-1.189-5.043a3.31 3.31 0 0 0-.06-.162 10.12 10.12 0 0 0-.456-.944c-.34-.638-.755-1.339-1.207-2.102l-.19-.321-.192-.326c-.556-.946-1.18-2.028-1.581-2.963-.193-.449-.424-1.064-.507-1.72-.067-.536-.137-2 1.102-3.054a2.09 2.09 0 0 0-.07-.378c-.196-.733-.639-1.529-1.155-2.455l-.103-.186c-1.017-1.83-2.248-3.688-3.52-5.608l-1.137-1.723c-.452-.692-.9-1.618-1.247-2.334l-.285-.582c-.478-.949-.781-1.369-.96-1.522-1.107-.949-1.623-2.133-1.916-2.827l-.131-.314c-.245-.584-.325-.773-.449-.938-.034-.023-.146-.091-.44-.235l-.096-.047c-.481-.233-1.433-.694-2.246-1.596l-.558-.603-.058-.062-.789-.856c-.492-.547-1.165-1.328-1.59-2.093-.753-1.355-1.61-2.606-2.552-3.979l-.797-1.167c-1.213-1.793-2.49-3.793-3.423-6.1a2.81 2.81 0 0 1 .099-2.335l-.041-.552-.001-.004-.077-1.12c-.065-1.125-.07-2.386.214-3.913.465-2.5 1.289-4.05 2.193-5.425l.595-.881c.584-.853 1.084-1.584 1.612-2.728l.004-.019a6.78 6.78 0 0 0 .082-.392c.07-.38.144-.879.229-1.496l.126-.937.483-3.363c.247-1.502.576-3.148 1.06-4.487.24-.661.575-1.415 1.069-2.066.316-.416.806-.927 1.491-1.276a11.88 11.88 0 0 0 .312-1.284c.141-.721.253-1.486.353-2.188l.029-.211c.078-.553.171-1.219.275-1.633.311-1.246.632-2.745.943-4.198l.003-.015.447-2.064c.248-1.112.913-2.845 1.463-4.281l.07-.182.813-2.16c-1.19-.323-2.64-.494-3.275-.529-1.785-.099-3.331-.556-4.657-1.006l-1.129-.394c-.877-.311-1.635-.58-2.501-.796-1.82-.455-3.809-.858-5.815-1.265l-3.99-.835c-1.591-.353-3.327-.65-5.143-.955l-.34-.058-5.068-.92c-2.458-.518-5.054-1.002-7.691-1.494l-10.698-2.142c-3.042-.695-6.265-1.418-8.914-1.418-1.966 0-3.932-.185-5.756-.357l-.091-.008c-1.895-.178-3.65-.34-5.382-.34-.841 0-1.688-.058-2.428-.109l-.133-.009c-.809-.055-1.503-.098-2.162-.09zm76.225 13.112h0zm3.89 189.02a2.822 2.822 0 1 0-5.539 1.08c.61 3.127.509 5.705.306 9.171-.101 1.712.67 2.961 1.63 3.781.576.493 1.38.931 1.832 1.178l.228.125c.253.145.652.468 1.279 1.043l.132.121.204.189 1.599 1.403c.87.677 2.254 1.704 3.72 2.607 1.302.801 3.12 1.799 4.801 2.03.01.004.02.01.033.016.115.058.28.158.523.327l.21.149.594.433 1.063.694.47.254 1.458.816.265.162.156.1-.094.793-.02.143c-.11.777-.297 2.097.006 3.461.2.9.421 2.147.552 3.383.136 1.294.147 2.34.046 2.948-.254 1.525-.256 3.045-.258 4.309v.164c-.002 1.378-.016 2.479-.205 3.52-.2 1.102-.056 2.108.045 2.742l.071.436.113.933c0 .636-.069 1.293-.16 2.133l-.005.047-.188 2.719-.353 24.024c0 1.559 1.264 2.822 2.822 2.822a2.82 2.82 0 0 0 2.822-2.822l.353-24.024c0-.653.069-1.321.16-2.158l.007-.067.185-2.674c0-.765-.133-1.548-.215-2.031l-.029-.17-.009-.056c-.091-.567-.083-.754-.067-.844.292-1.604.295-3.189.297-4.5v-.021l.181-3.554c.231-1.386.149-3.053-.001-4.469a37.46 37.46 0 0 0-.655-4.015c-.062-.281-.039-.635.095-1.602l.016-.113c.11-.778.304-2.152-.094-3.543-.206-.722-.628-1.213-.823-1.425-.241-.263-.502-.484-.719-.654-.438-.343-.946-.668-1.39-.934l-1.866-1.044-.004-.002-.224-.121c-.188-.104-.332-.211-.571-.388l-.814-.587c-.563-.392-1.675-1.144-3.007-1.301-.341-.04-1.257-.409-2.613-1.245-1.222-.752-2.427-1.642-3.215-2.255-.322-.251-.662-.565-1.107-.978l-.311-.287-.17-.156c-.59-.541-1.417-1.281-2.291-1.781l-.463-.258-.028-.015-.157-.087-.093-.052-.081-.046c.185-3.261.28-6.316-.435-9.977z"
        fill="#fafa19"
      />
      <path
        d="M250.291 145.967c-.864.298-2.309 1.081-3.212 1.741l-.359 1.243-.706 2.116.109 2.007.624 9.436.935 10.35c.003.717-.191.85-1.931 1.32-.53.144-1.567.624-2.624 1.112l-2.756 1.171-.654 9.528-6.924.184c-6.878.184-8.253.427-12.175 1.575-1.493.438-2.825 1.103-3.527 2.117l-1.411 1.411-5.644.705-4.593.855-5.103.954-6.188 1.198c-6.637 1.249-18.469 4.014-26.612 6.219-1.957.53-4.063 1.356-4.063 1.356-1.411.705-2.602 1.658-3.528 2.822-7.142 8.974-11.212 14.115-15.91 21.762-1.224 1.991-2.356 3.621-2.517 3.621s-2.26-.981-4.664-2.181c-5.316-2.652-9.462-4.357-15.58-6.408-7.95-2.666-10.985-3.247-17.765-3.391-3.096-.066-4.615.072-5.643.706-.188.116-.43.241-.683.372-.639.33-1.347.697-1.433 1.039-.132.524.004 2.111.758 5.081 2.876 11.335 7.516 23.621 13.511 35.775 1.511 3.063 2.662 6.307 2.662 6.409s-.772.497-1.411.705c-.397.13-1.257.508-2.446 1.031l-2.492 1.086c-11.356 4.872-23.948 10.431-34.629 16.682-2.417 1.414-4.472 2.571-4.568 2.571s-.973.529-1.95 1.176-4.109 2.622-6.96 4.391c-2.241 1.39-3.724 2.973-4.415 3.71-.188.201-.317.339-.387.393-.572.445-.889 2.467-.706 7.76l.183 6.202c.188 7.111.325 12.266 1.597 22.594.713 5.789.551 8.502.422 10.674-.044.747-.085 1.43-.085 2.152 0 1.059-.927 2.123-1.589 2.882-.22.253-.41.471-.528.645-.716 1.059-1.193 2.366-1.058 3.527.039.338.026.66.008 1.133a34.23 34.23 0 0 0-.008 2.835c.088 2.523.297 5.55.465 6.728.153 1.071.152 1.503.15 2.18v.212c0 1.484.541 3.219 3.265 5.959l3.527 3.528-9.876 2.821c-4.039.938-13.972 5.003-16.931 6.35l-.087.039c-.66.301-2.988 1.362-4.851 2.077-6.619 2.54-24.623 11.064-25.396 11.993-1.203 1.443-.987 3.249 3.527 9.876 4.782 7.019 17.006 23.184 21.164 28.218 4.091 4.953 5.995 9.298 6.349 14.109.327 4.445 5.17 10.023 8.108 13.406l.614.709c1.023 1.186 3.265 3.571 4.983 5.299s3.451 3.569 3.85 4.091 1.095 1.136 1.547 1.365c1.923.975 9.24 3.332 27.457 4.053 3.153.125 5.552.127 7.982.129 4.044.003 8.172.006 16.004.577 3.82.278 11.731.667 17.636.705 10.208.066 26.702.353 29.629.706h2.116l.706 2.822c.179 1.955.508 4.552 1.41 6.349 4.939 7.76 11.812 17.787 18.342 24.69l2.822 3.528 4.233-.706c1.433-.25 3.485-.758 5.383-1.228l3.788-.888 15.924-3.085 22.875-4.675 22.556-5.319 4.251-1.03c2.466-.597 4.884-1.27 6.913-1.835l3.669-.987c2.213-.535 4.148-1.346 4.233-1.411s.62-3.382.705-7.054l.706-7.055c1.136-.049 4.514.078 8.746.238l18.061.468 12.699-.135c4.7-.082 7.242-.126 9.875.135 4.952.49 5.377.473 7.055 0 .489-.139 1.306-.226 2.202-.321.918-.099 1.918-.205 2.736-.385l1.071-.234 5.278-1.177c.659-.155 1.713-.482 2.98-.876 2.008-.623 4.549-1.412 6.896-1.946 3.438-.781 5.623-1.487 7.8-2.19 2.131-.689 4.254-1.375 7.534-2.125l6.189-1.406c7.429-1.673 23.355-5.582 32.646-8.013l6.743-1.849 7.517-2.053.706-1.411c.943-6.266 1.626-35.877.705-47.265-.245-3.03-.053-3.972-.008-4.194.004-.017.006-.03.008-.039.105-.648-.841-1.35-2.696-2.728l-.126-.093c-4.584-3.406-12.944-8.897-16.225-9.877h-1.411l.088-7.198c.068-2.979.179-5.761.245-6.181.115-.72.479-.852 6.465-2.347 8.816-2.2 13.361-3.446 13.659-3.742.139-.139.331-4.825.425-10.414l.059-3.984c.047-3.559.081-6.127.222-7.05.304-1.977-.491-3.677-1.221-5.237l-.189-.407c-.178-.384-.29-1.007-.426-1.769-.207-1.15-.469-2.613-1.097-4.04l-1.9-4.315-.123-7.088c-.289-16.58-1.269-40.219-1.733-41.757-.607-2.016-2.464-6.307-4.306-9.946-1.204-2.38-.639-3.839.117-5.791l.297-.777c.389-1.049-4.819-9.59-9.612-16.923-2.182-3.338-2.437-3.565-3.752-3.356-1.325.211-1.425.11-2.633-2.653-.483-1.102-1.981-4.292-3.33-7.088l-2.453-5.085-1.5-2.284 2.822-10.582c1.055-.678 2.033-1.777 2.116-2.116l.23-.914c.631-2.487 1.987-7.822 1.849-9.776-.113-1.609-.285-4.124 2.154-4.124.675 0 .921-.962 1.983-5.124l.133-.52c1.331-5.208 2.469-12.477 2.116-13.404-.341 0-1.608-.375-3.287-.872l-3.842-1.106c-10.598-2.891-23.428-5.684-33.349-7.261l-5.724-.931c-6.388-1.091-20.731-2.531-30.48-3.061l-3.034.533-6.349 2.117c-2.638 1.1-6.192 2.769-9.171 4.232l-4.232 2.822-4.756-.993-8.663-1.179c-3.404-.451-6.459-.924-6.79-1.051-.561-.217-1.009-.9-.955-5.242.05-4.024-.238-4.39-.705-4.938-.573-.672-1.962-1.449-6.248-2.707-.817-.24-1.832-.436-2.582-.581-.578-.111-.998-.193-1.047-.24-.035-.034.006-.513.074-1.315.144-1.692.41-4.826.342-8.275l-.416-7.34-2.013-3.688c-3.978-3.154-11.918-7.609-13.544-7.6-.255.002-1.171.247-2.035.544zm-84.166 61.863l23.448 6.892c6.458 1.837 20.373 5.104 26.523 6.508l3.075 37.521c-2.306-.638-7.611-1.915-10.379-1.915s-7.303 3.829-9.225 5.743l-21.91 4.212c-3.459-5.871-10.609-17.842-11.532-18.76s-12.684-9.062-18.45-13.018l18.45-27.183zm75.34 18.377l-15.375-2.68 3.844 23.355 11.531-20.675zm33.827-2.68l-19.989 2.68-14.606 27.949 22.679-1.914c5.227-.613 15.247-2.042 19.603-2.68l-7.687-26.035zm33.057 13.401l-16.529-2.298 5.766 15.698 13.454 2.297-2.691-15.697zm33.057 3.828l-18.45-1.914 2.69 16.08 33.827 4.977-18.067-19.143zm37.67 16.08l-13.453-13.783 9.994 1.915 8.072 13.4-4.613-1.532zm6.618 174.295h-4.233v7.055l4.233-1.411v-5.644zm-48.676 18.342v-4.938l7.76-2.117v5.644l-7.76 1.411zm-106.524 18.342v7.054l4.233-1.411v-7.054h-2.822l-1.411 1.411zm-45.854 11.287v5.643l15.52-4.938v-4.938l-15.52 4.233z"
        fill="#fff"
      />
      <path
        d="M248.3 146.879c-2.644 1.6-2.922 2.025-2.668 4.067.647 5.219 1.704 15.924 1.891 19.173l.202 3.487-4.057 1.061-4.056 2.502v8.646l-8.289.442c-9.3.495-13.287 1.391-14.931 3.357-.852 1.019-4.643 2.022-15.933 4.216-13.562 2.635-31.219 6.711-36.847 8.505-1.626.519-3.636 2.481-7.012 6.849-4.295 5.555-13.983 19.867-14.501 21.419-.117.35-3.541-.93-7.609-2.843-16.385-7.702-35.061-11.599-38.322-7.995-1.084 1.198-1 1.845 1.258 9.7 3.847 13.379 6.125 19.343 12.024 31.482 1.719 3.538 2.991 6.654 2.824 6.923s-1.82 1.067-3.675 1.774c-10.784 4.108-35.471 17.112-49.934 26.304l-3.175 2.017-2.768 3.363v2.822c-.271 4.817.344 22.781 1.679 33.111.988 7.64 1.434 10.964-.974 14.859-1.477 2.391-2.341 2.488-1.937 9.11.619 10.146.88 11.01 4.416 14.617l3.162 3.224-2.671.882c-1.469.485-5.687 1.778-9.373 2.876s-10.194 3.284-14.462 4.859c-7.985 2.948-28.304 13.171-29.928 14.52-1.401 1.163-1.648 2.424.419 5.977 2.246 3.86 14.562 20.87 22.263 30.749 5.48 7.03 8.304 12.665 8.304 16.571 0 4.174 4.726 9.519 13.457 18.659l4.938 5.643 5.443 1.805c2.991.36 12.44 2.02 21.364 2.428s20.652.013 25.695.385 13.644.685 19.112.696a517.38 517.38 0 0 1 19.576.482l9.635.463v2.388c0 1.314.592 3.248 1.313 4.299s2.597 4.134 4.166 6.85c4.161 7.205 11.863 16.604 15.738 20.415 1.934 1.902 3.388 2.935 5.238 2.502 1.552-.364 9.647-1.957 17.989-3.542 16.617-3.157 42.127-8.79 61.374-13.551l11.287-3.045 1.259-6.754.206-7.355 8.546.15c11.448-.616 28.02-.516 37.96.229 6.938.52 8.93.415 13.756-.725l31.746-7.34c22.052-5.076 34.634-9.337 52.609-14.183 2.608-.703 2.441-.518 2.822-2.822.542-3.276 1.317-40.563.736-47.535l-.437-5.25-4.585-3.115c-2.522-1.713-7.204-4.391-10.406-5.948l-5.82-2.833.01-4.675c.016-7.66-.509-7.175 10.792-9.981 9.424-2.341 10.016-2.588 10.114-4.233.058-.961.185-6.984.283-13.386l.176-11.64-4.921-10.612-.505-20.796c-.633-26.122 1.108-25.856-2.491-33.537-2.585-5.515-4.233-8.466-3.528-9.387 0 0 .706-1.463.706-1.9 0-1.169-6.065-12.043-9.086-16.535-1.566-2.332-2.005-3.794-2.907-3.923-1.147-.164-3.538-2.165-6.239-7.932-3.457-7.379-3.528-7.661-3.201-12.836.306-4.846-.335-5.678 1.68-7.451 2.127-1.869 3.141-3.651 3.353-8.511.295-6.749-.087-7.433 1.941-8.199 2.236-.844 2.774-1.354 4.582-10.802 1.612-8.424 2.069-8.261-3.404-9.581l-15.344-3.694c-17.24-4.151-35.725-6.94-53.595-8.089l-7.373-.505-8.499 2.879-10.059 4.606c-3.27 1.611-3.494 1.626-10.8.734-11.877-1.452-11.199-1.037-11.611-7.108l-.353-5.187-4.36-1.468c-2.397-.807-4.507-1.626-4.687-1.82s-.484-4.472-.675-9.506l-.454-8.526-2.267-2.631c-2.905-2.454-10.203-6.603-12.6-7.165-1.196-.279-2.715.163-4.716 1.375zm11.467 4.055l6.621 3.704.016 4.739c.011 3.464-.223 4.671-.867 4.484-.484-.14-2.995-.793-5.578-1.449l-4.698-1.194-.754-4.348c-.827-4.768-3.36-7.937-5.828-7.292-1.656.433-1.704-.635-.073-1.586 2.316-1.349 4.539-.762 11.161 2.942zm-.402 14.285c1.649.582 4.07 1.059 5.379 1.059h2.381v5.266c0 6.165-.469 6.646-7.041 7.243l-4.029.365-.455-3.792c-.651-5.414-.574-11.199.148-11.199.34 0 1.967.476 3.617 1.058zm13.756 11.52l3.527 1.178.403 13.695-1.965 1.006c-3.243 1.662-9.425 2.706-14.579 2.461l-4.854-.231-.084-5.261c-.094-5.877-.289-6.106-6.61-7.765-5.455-1.431-3.342-2.145 5.175-1.749 7.365.344 8.481.232 11.287-1.126 1.713-.83 3.114-1.956 3.114-2.503 0-1.201.13-1.192 4.586.295zm-8.978 5.694c-5.477 1.842-6.596 3.057-3.19 3.462 3.89.463 10.404-2.561 10.404-4.831 0-.925-.906-.753-7.214 1.369zm73.527 1.209c16.407 1.819 42.962 6.727 55.378 10.234l2.821.797-7.054 2.254c-7.491 2.393-22.099 8.503-23.28 9.737-.486.508-.267.574.705.214 20.483-7.607 30.952-10.942 31.773-10.121.202.202-.172 3.617-.831 7.588-1 6.021-1.443 7.321-2.667 7.822-10.47 4.292-20.393 7.76-20.814 7.275-.291-.335-2.462-3.307-4.826-6.605-5.921-8.265-8.021-10.366-11.191-11.197-17.255-4.52-33.603-8.018-43.294-9.262-6.402-.821-12.116-1.654-12.698-1.85-.61-.205 1.334-1.385 4.585-2.784 3.104-1.335 7.231-3.2 9.171-4.145 3.933-1.914 4.573-1.913 22.222.043zm-45.096 6.225c6.512.992 17.371 3.347 23.579 4.272 12.943 1.928 41.961 8.884 44.711 10.718l1.849 1.232-4.233.847-13.726 2.669-9.494 1.821-2.499-2.394c-1.374-1.317-3.818-3.054-5.43-3.861-4.958-2.479-21.077-7.507-35.339-11.023-9.464-2.333-13.58-3.643-13.58-4.322 0-1.309.461-2.045 14.162.041zm-64.388 4.281c24.672 3.943 47.664 8.79 60.102 12.672l12.564 3.927c5.583 1.746 10.159 3.614 11.287 4.607 1.044.92 1.569 1.681 1.167 1.693s-9.926 1.43-21.164 3.15c-33.421 5.115-39.37 5.683-48.942 4.67-18.144-1.922-43.789-7.757-70.057-15.941-7.839-2.442-10.786-3.772-10.021-4.525.674-.661 49.854-11.746 53.072-11.96.506-.034 5.902.735 11.992 1.707zm62.924 1.448c15.652 4.092 31.86 9.158 35.987 11.25 2.231 1.13 10.408 8.994 27.111 26.071 13.154 13.45 24.894 24.964 26.087 25.588 1.451.758 4.521.985 9.632 1.201h7.76l1.435 2.782c1.907 3.1 8.387 15.73 8.387 16.349 0 .765-13.555-.312-19.697-1.565-2.941-.599-7.727-2.038-10.637-3.197-4.501-1.793-5.818-2.733-8.818-6.296-5.283-6.273-35.288-35.799-46.62-45.877l-9.937-8.835-12.99-4.326c-11.016-3.667-26.505-7.827-39.445-10.594l-3.175-.679 3.175-.079c5.434-.137 11.202-1.348 15.024-3.156 2.019-.955 3.829-1.765 4.023-1.8s5.908 1.388 12.698 3.163zm76.722 18.66c5.731 8.647 12.723 20.328 19.845 33.148l5.682 10.229-4.375.215c-2.407.118-4.475-.083-4.597-.446s-1.367-2.523-2.768-4.8l-11.316-18.954c-4.821-8.148-10.311-16.943-12.201-19.544l-3.434-4.731 3.317-1.024c1.825-.563 3.789-.971 4.364-.906s3.043 3.13 5.483 6.813zm-202.998-6.068c0 .159-2.142 3.147-4.762 6.64s-6.507 9.222-8.641 12.731-4.277 6.395-4.762 6.411-.882-.154-.882-.38c0-1.43 8-13.19 15.918-23.398 1.518-1.957 3.129-2.989 3.129-2.004zm6.758 2.126c2.685.94 7.671 2.541 11.081 3.558l6.199 1.848-.465 2.615c-.255 1.438-.673 2.846-.928 3.129s-2.083-.004-4.063-.637-4.083-.965-4.675-.738c-1.106.425-4.102 11.41-3.532 12.951.692 1.869 21.084 9.123 23.76 8.451 1.885-.473 2.728-2.127 4.323-8.487 1.241-4.947.805-6.763-1.623-6.763-.597 0-2.798-.54-4.889-1.199l-3.804-1.199.472-2.858c.26-1.571.588-3.055.73-3.296s4.831.692 10.421 2.077l10.163 2.517 1.162 9.21c1.158 9.169 2.524 25.934 2.148 26.368-.108.125-1.417-.111-2.908-.525-6.165-1.712-10.957-.589-15.565 3.649-1.178 1.082-3.426 1.681-9.047 2.408-4.114.532-8.617 1.442-10.005 2.022s-2.591.972-2.671.869-2.783-4.426-6.006-9.609c-6.287-10.11-8.159-11.996-17.97-18.111-2.91-1.814-5.291-3.532-5.291-3.818 0-1.021 17.034-25.674 18.045-26.117.031-.013 2.253.745 4.938 1.685zm219.609 9.401c-.151 7.337-.503 8.039-5.298 10.575l-4.321 2.286-2.909-5.024c-1.6-2.764-2.909-5.224-2.909-5.466 0-.416 13.866-6.334 14.991-6.397.291-.017.492 1.796.446 4.026zm-75.504-1.006c.824.993 5.582 19.086 7.859 29.891.752 3.568 2.637 10.968 4.189 16.443 4.167 14.706 4.146 14.481 1.499 15.85-1.516.784-3.581 1.078-6.55.935l-4.337-.209-.912-3.527c-.501-1.94-2.836-13.369-5.188-25.397l-5.415-27.16-1.204-5.638c-.07-.365 6.159-1.937 8.137-2.054.631-.037 1.496.352 1.922.866zm-204.124 2.388c7.043 1.587 19.778 6.626 28.117 11.126 9.315 5.026 21.598 12.822 24.686 15.667 2.313 2.131 7.157 9.815 12.592 19.972l7.081 13.051a638.09 638.09 0 0 1 9.461 18.191c4.063 8.176 4.664 9.832 3.775 10.395-1.802 1.139-2.616.776-3.589-1.602-1.865-4.557-18.567-36.395-24.466-46.64-6.833-11.866-8.179-13.199-21.218-21.013-17.659-10.582-32.283-16.666-44.472-18.502-5.858-.882-5.988-.941-3.607-1.644 2.704-.797 4.259-.664 11.64.999zm123.101 4.544c3.298.448 6.093.89 6.213.982s-1.122 2.346-2.756 5.007-4.153 7.008-5.595 9.657l-2.624 4.818-.48-4.112c-.265-2.262-.94-6.607-1.5-9.657-1.243-6.769-1.256-7.506-.136-7.507.485 0 3.58.365 6.878.812zm40.771 2.54c1.317 3.067 6.494 20.047 6.494 21.3 0 .294-2.461.751-5.467 1.014s-8.007.78-11.111 1.151c-10.406 1.243-23.011 2.258-23.386 1.884-.82-.82 13.448-26.549 14.775-26.645.468-.035 3.549-.474 6.847-.977 10.258-1.566 10.193-1.578 11.848 2.273zm-21.724-.954c0 .155-1.323 2.456-2.939 5.115-3.362 5.53-12.237 23.898-18.014 37.284-2.697 6.251-8.929 22.287-9.731 25.044-.282.97-.924 2.716-1.426 3.88s-1.098 2.948-1.323 3.965c-.309 1.396-1.293 2.229-4.015 3.4-1.983.853-3.741 1.415-3.908 1.248-.358-.358 9.907-27.956 11.734-31.547.693-1.361 2.428-5.488 3.857-9.171 3.128-8.065 9.964-21.364 16.356-31.822 4.46-7.299 4.807-7.677 7.05-7.677 1.297 0 2.359.127 2.359.281zm132.625 8.89c0 1.94-.259 3.527-.575 3.527s-1.135-1.176-1.821-2.613c-1.191-2.499-1.191-2.653.004-3.527 2.036-1.488 2.392-1.1 2.392 2.613zm-85.76.794c3.518.436 6.615.992 6.883 1.234.548.497 2.687 10.313 2.687 12.336.001 1.411-.168 1.406-8.883-.308l-3.592-.706-2.4-6.146-2.638-6.675c-.316-.696.385-.673 7.943.265zm-6.83 6.513c1.823 4.555 2.27 6.401 1.692 6.979-.433.433-.962.613-1.175.4-1.009-1.01-5.255-12.322-4.936-13.153.737-1.919 2.003-.264 4.419 5.774zm39.603-2.428l8.033 1.32 17.088 17.176-3.527-.454c-5.798-.746-27.485-4.676-27.862-5.05-.192-.19-1.022-3.495-1.844-7.345-1.007-4.712-1.238-6.994-.709-6.983.432.009 4.402.61 8.821 1.336zm42.405 6.399c2.995 3.417 6.429 9.886 5.248 9.886-1.055 0-1.829-.711-9.128-8.385l-4.233-4.45 3.175.468c2.241.331 3.693 1.06 4.938 2.481zm-91.144 4.383c.465.466.846 1.229.846 1.697 0 1.018-5.121.597-7.638-.629-1.5-.731-1.53-.843-.352-1.308 2.075-.817 6.226-.678 7.144.24zm-13.385 3.425l1.64 2.078-2.346.01c-1.29.007-2.796.297-3.347.644-.649.411-1.583.251-2.658-.453-1.087-.712-2.507-.95-4.114-.689-1.941.316-2.604.119-3.168-.935-.627-1.172-.394-1.386 1.939-1.777 1.459-.244 2.97-.55 3.358-.682s2.134-.247 3.88-.256c2.682-.015 3.429.305 4.816 2.06zm-24.024 4.528c.476 2.512.866 4.848.866 5.19s-1.983.824-4.409 1.07c-3.495.353-4.73.813-5.962 2.217-1.93 2.2-2.327 2.216-2.327.095 0-2.177 4.554-12.169 5.767-12.654.515-.205 1.894-.399 3.067-.429 2.073-.054 2.156.071 2.998 4.511zm-30.573.124c2.354.639 4.52 1.372 4.814 1.628.582.506-2.933 9.023-9.104 22.06-2.155 4.551-5.108 11.661-6.565 15.799-2.122 6.03-3.021 7.721-4.525 8.509l-1.877.983-3.164-6.817c-1.741-3.75-3.163-7.651-3.161-8.67.008-3.683 1.605-7.507 4.234-10.135 2.384-2.384 2.874-2.595 4.554-1.956 2.89 1.099 3.809.796 1.437-.473-2.817-1.508-3.154-2.135-3.148-5.866.008-5.314 3.908-11.951 8.762-14.911 2.609-1.591 2.457-1.588 7.743-.151zm59.777.609c2.456.587 8.366 2.228 13.132 3.645l8.667 2.577-2.087 2.175c-2.121 2.211-4.476 8.206-5.359 13.642-.374 2.299-.845 3.075-2.013 3.318-12.579 2.623-11.825 2.849-11.298-3.397.29-3.42.179-5.351-.326-5.663-.769-.475-.931.155-2.052 7.971l-.547 3.819-4.544.926c-2.499.509-4.671.798-4.827.642-.642-.642 2.218-8.67 3.861-10.84 2.422-3.196 1.624-3.582-1.068-.516-2.005 2.284-4.357 8.204-4.357 10.968 0 .942-2.055 1.502-11.111 3.03l-12.698 2.327c-1.349.384-1.587.182-1.587-1.348 0-.991.315-2.629.701-3.643.63-1.657.967-1.8 3.35-1.424 2.649.419 2.65.418.808-.644-2.655-1.531-3.709-4.635-3.259-9.6.413-4.553 2.856-10.426 4.619-11.102 3.621-1.39 21.581 3.007 28.175 6.897 4.234 2.498 3.305.98-1.15-1.88-2.329-1.495-4.385-3.281-4.569-3.969-.449-1.684.833-6.215 2.191-7.743 1.336-1.503 1.723-1.512 7.348-.168zm34.27 9.288c2.776.774 3.79 1.417 4.051 2.57 1.396 6.162 1.763 8.481 1.398 8.846-.448.448-15.772 2.825-18.596 2.885-1.657.034-1.677-.042-1.206-4.643.656-6.405 1.964-9.255 4.804-10.467 2.388-1.021 3.237-.949 9.549.809zm-196.079 1.073c1.824 1.824.806 2.477-4.561 2.931-2.974.252-5.528.337-5.674.19-.237-.236 8.025-3.847 9-3.933.214-.019.769.347 1.235.812zm270.033 7.894c2.297.594 7.865 1.465 12.373 1.935l9.14.612 3.527 6.658 2.822 4.939v21.163l-5.168 1.672-4.056.993v15.466c0 12.514.186 15.537.975 15.84.536.206 2.783-.151 4.991-.793s4.098-1.058 4.2-.926 1.17 2.378 2.373 4.989c1.436 3.118 1.927 4.909 1.43 5.216-.416.257-2.54 1.054-4.718 1.77-3.48 1.144-3.618 1.254-1.139.909 1.552-.216 3.537-.564 4.409-.774 1.52-.365 3.453-.685 3.456 3.609.003 2.467-.651 7.711-.404 11.432l-.561 7.081-8.898 2.229c-11.077 2.774-11.053 2.774-11.053.065 0-3.032-.845-4.308-4.911-7.409-3.375-2.574-3.554-2.876-3.554-6.011 0-7.485-9.138-20.49-17.236-24.529-5.24-2.615-15.063-4.012-21.343-3.035-9.362 1.455-18.836 7.025-24.38 14.332-3.298 4.347-8.555 15.002-9.693 19.644-.428 1.746-.938 8.096-1.135 14.11s-.578 11.143-.85 11.399-5.329 1.454-11.238 2.662l-11.64 2.512c-.493.172-5.657 1.126-11.477 2.119a558.59 558.59 0 0 0-20.231 3.902c-11.002 2.39-12.573 2.52-12.573 1.04 0-.581-1.064-2.247-2.364-3.703-1.828-2.047-2.462-3.496-2.792-6.381-.514-4.49-3.864-11.508-7.225-15.136-7.622-8.229-13.578-11.133-22.891-11.165-7.699-.026-12.255 1.054-19.4 4.599-8.126 4.032-13.619 8.411-18.006 14.355-7.026 9.519-10.093 17.097-10.91 26.953-.241 2.91-.788 5.997-1.214 6.859-1.048 2.12-.029 1.84-29.833 8.203-3.203.684-5.186.814-5.644.369-.406-.394-.809-6.538-.947-14.441l-.242-13.755 3.164-3.383c5.242-5.604 5.7-6.984 5.166-15.575-.255-4.087-.648-14.255-.874-22.597-.27-9.97-.689-15.449-1.222-15.991-.447-.453-3.352-2.158-6.456-3.789-12.419-6.526-60.994-38.745-68.429-45.388l-2.822-2.521 1.751-1.378c5.465-4.301 9.394-6.014 15.059-6.561 3.113-.301 5.791-.416 5.951-.256s-2.226 1.742-5.303 3.517c-6.778 3.91-8.166 5.256-6.999 6.79 1.58 2.075 12.862 10.756 20.581 15.836 10.165 6.689 17.312 10.696 31.04 17.402 12.835 6.27 16.196 6.926 19.875 3.881 6.097-5.047 35.136-19.544 53.845-26.881l7.154-2.87c4.156-1.686 5.064-1.821 8.036-1.187 2.54.542 4.306.47 7.307-.299 5.001-1.28 7.273-2.93 7.544-5.48.118-1.099.345-2.129.504-2.289.469-.469 21.935-4.941 31.535-6.57a746.43 746.43 0 0 0 19.047-3.568c18.681-3.782 39.12-7.052 44.08-7.052.756 0 3.185 6.055 3.185 7.94 0 .75-1.153 1.186-4.056 1.53-2.232.265-5.803.941-7.937 1.502l-3.88 1.02 5.291-.373c2.91-.206 6.527-.706 8.037-1.113 3.507-.943 3.669-.669 4.147 7.019.392 6.308 2.94 15.319 5.546 19.62l1.349 2.225-2.391 1.478c-3.216 1.988-12.077 11.344-16.099 16.999-9.433 13.262-14.698 30.209-14.698 47.311v7.65l-2.645.445c-1.455.245-7.249 1.388-12.875 2.539l-16.225 3.102-7.936 1.43c-1.707.369-1.94.211-1.94-1.325 0-2.819-2.687-10.712-6.04-17.744-4.369-9.165-10.248-15.431-18.335-19.544-3.992-2.03-6.102-3.526-6.298-4.464-.162-.776-.98-8.078-1.818-16.226s-1.648-14.947-1.8-15.108c-.77-.818-.109 10.177 1.282 21.315l1.567 12.556 6.174 3.532c4.17 2.387 7.466 4.952 10.155 7.903 5.691 6.245 11.321 18.057 12.987 27.247.677 3.732.631 4.658-.302 6.081-1.768 2.699-1.213 2.986.931.481 1.533-1.791 2.828-2.462 5.792-3.004 2.099-.385 11.318-2.216 20.484-4.071 14.509-2.935 16.854-3.248 18.112-2.412 1.539 1.022 12.851 2.147 11.957 1.189-.292-.312-2.196-.801-4.233-1.086s-4.576-.86-5.643-1.276l-1.94-.755.006-7.249c.006-8.838.784-14.069 3.597-24.179 2.429-8.73 4.621-13.551 9.504-20.896 4.029-6.06 12.811-15.681 16.986-18.609 1.66-1.164 3.028-2.51 3.041-2.99s-1.061-3.496-2.386-6.702c-2.754-6.665-4.646-14.994-4.646-20.447 0-2.058-.63-5.464-1.398-7.567s-1.279-3.944-1.133-4.09 2.148-.531 4.45-.856 5.748-1.408 7.658-2.406c2.109-1.101 6.106-2.233 10.175-2.88l18.339-2.897c6.399-1.008 11.755-1.951 11.901-2.097s2.077.651 4.292 1.769 5.908 2.52 8.205 3.114zm-47.322-2.68c3.621.828 3.618 1.251-.015 2.046-3.714.813-4.539.454-4.56-1.981-.007-.893.365-1.171 1.224-.915.679.201 2.187.584 3.351.85zm-195.62 6.694c9.987 3.272 24.348 11.164 31.25 17.176l2.116 1.843-2.822-.45c-6.653-1.06-17.921-5.341-25.608-9.727-8.059-4.598-15.661-9.977-15.661-11.083 0-.847 3.582-.099 10.725 2.241zm233.009-.311c-.776.611-2.469 1.568-3.763 2.128-2.794 1.208-21.992 5.181-25.036 5.181-1.168 0-1.926.199-1.683.441.507.508 15.21-.881 20.958-1.979 4.263-.814 7.691-2.428 10.935-5.146 2.314-1.94.999-2.523-1.411-.625zM80.864 293.788c-.03.719-14.087 8.709-14.087 8.007 0-.957 2.276-2.603 7.76-5.614 5.395-2.961 6.366-3.328 6.327-2.393zm144.639 1.94c0 2.041-.258 2.469-1.486 2.469-1.139 0-1.368-.289-.979-1.235a28.66 28.66 0 0 0 .864-2.469c.608-2.118 1.601-1.352 1.601 1.235zm52.203 3.944c-3.298.715-13.615 2.758-22.927 4.54-39.483 7.557-65.73 15.517-92.988 28.199-6.983 3.25-3.949 2.661 3.812-.738 21.917-9.602 52.427-18.791 80.711-24.311 22.822-4.453 43.773-9.389 38.447-9.056-.582.036-3.757.651-7.055 1.366zM138.15 310.104c2.202.385 5.059 1.247 6.349 1.915l2.346 1.217-4.347.889c-4.7.961-7.074 2.188-10.644 5.501-3.031 2.813-2.968 4 .072 1.332 3.735-3.279 8.787-5.396 13.619-5.707l4.343-.279 4.117 3.987c4.815 4.664 4.5 5.349-2.215 4.81-3.724-.299-5.05-.069-8.366 1.449-2.167.992-5.459 3.21-7.314 4.929-5.114 4.737-5.992 5.046-9.397 3.308-2.376-1.212-2.796-1.73-2.442-3.017l.427-1.554-1.414 1.623c-1.325 1.521-1.541 1.558-3.439.576-3.407-1.762-3.942-2.835-2.655-5.323 1.915-3.703-.179-2.374-2.422 1.537-1.167 2.036-2.227 4.005-2.354 4.375-.242.704-2.543-.514-14.378-7.609-5.529-3.314-7.015-4.517-6.439-5.211 1.003-1.209 1.987-1.142 1.987.133 0 .98 6.204 5.519 10.772 7.881 1.906.985 2.208.98 3.237-.048 1.75-1.751.389-3.164-6.601-6.857l-6.206-3.278 2.099-1.085c2.028-1.049 2.294-.985 7.807 1.853 5.629 2.897 5.728 2.92 7.176 1.609.808-.731 1.469-1.567 1.469-1.858s-1.794-1.542-3.988-2.78c-2.989-1.687-3.741-2.408-2.999-2.878 1.698-1.075 4.077-.717 7.813 1.175 3.561 1.806 3.614 1.81 4.967.457 1.245-1.245 1.268-1.468.256-2.48-.61-.611-1.111-1.288-1.111-1.504 0-.59 15.29.111 19.876.912zm-21.672.199c1.529.696 2.492 2.003 1.477 2.003-.9 0-3.913-1.717-3.913-2.23 0-.777.293-.749 2.436.227zm15.553 1.443c-2.468.863-6.96 4.065-6.436 4.588.197.198 1.277-.296 2.401-1.096s3.603-2.088 5.508-2.861c3.552-1.44 2.334-1.962-1.473-.631zm24.196 1.921c.657.357.455.707-.715 1.241-1.336.608-2.074.43-4.09-.989l-2.461-1.732 3.175.491c1.746.271 3.587.716 4.091.989zm-48.982 1.257l3.869 2.07c.136.086.044.486-.205.888-.483.781-9.565-3.317-9.565-4.317 0-1.069 2.311-.536 5.901 1.359zm54.365 4.196c.958 3.815 1.008 4.807.262 5.28-1.474.935-1.793.732-2.63-1.669-.436-1.25-1.611-3.127-2.612-4.171l-1.819-1.899 2.013-1.091c1.108-.6 2.372-1.104 2.81-1.12s1.327 2.086 1.976 4.67zm138.671-4.231c-7.199 1.12-14.968 4.884-16.602 8.044-1.389 2.688-1.308 3.649.502 5.951 1.503 1.911 1.653 1.943 6.878 1.512 5.605-.463 14.101-2.439 16.877-3.925 2.138-1.144 3.841-5.261 3.264-7.888-.796-3.622-4.131-4.751-10.919-3.694zm8.624 2.587c1.579 2.484 1.167 2.662-13.21 5.712l-10.052 2.241c-1.748.49-1.931.125-.9-1.802 2.569-4.801 21.891-9.72 24.162-6.151zm103.763 13.237l.397 13.821-3.589.829c-1.974.455-3.659.744-3.744.64s-.319-6.459-.517-14.124l-.362-13.935 3.268-.977c1.797-.537 3.467-.773 3.709-.526s.619 6.67.838 14.272zm-310.984-8.707c5.003 2.505 6.426 3.703 4.4 3.703-.496 0-3.116-1.426-5.82-3.169s-4.68-3.173-4.39-3.175 2.904 1.186 5.81 2.641zm-36.197 5.861c1.505 5.328 1.764 12.933.423 12.485-1.244-.414-2.577-5.569-3.118-12.053-.587-7.036.767-7.253 2.695-.432zm307.764-2.45c9.245 5.575 17.107 14.297 21.864 24.258 1.881 3.938 2.518 4.795 2.518 3.389 0-2.696-5.004-11.993-8.925-16.582-4.104-4.804-9.769-9.319-14.748-11.758-5.301-2.595-5.63-2.274-.709.693zm-217.936 10.161c-.246.399.036.518.664.277 1.222-.469 1.446-.975.431-.975-.365 0-.857.314-1.095.698zm-38.14 25.681c2.972 5.175 4.012 13.068 2.186 16.6-1.631 3.153-4.884 3.201-7.211.105-1.417-1.884-3.047-9.631-3.047-14.482 0-3.687.287-4.903 1.421-6.037 1.343-1.343 1.518-1.357 3.204-.253.98.643 2.532 2.472 3.447 4.067zm282.669 10.523c-.061 5.867.153 8.883.611 8.6.816-.504.836-8.952.032-14.109-.432-2.776-.569-1.603-.643 5.509zm-217.374-5.401c-4.095 1.976-6.651 3.926-11.314 8.63-6.955 7.017-10.695 12.794-13.468 20.803l-1.966 5.678-6.555 1.628c-7.771 1.931-8.639 2.22-8.145 2.714.207.207 3.188-.262 6.627-1.04l7.595-1.627c.74-.115 1.415-.696 1.502-1.289.264-1.807 4.444-11.412 6.503-14.943 4.839-8.299 13.578-16.73 21.504-20.746 1.849-.937 3.361-1.857 3.361-2.044 0-.497.104-.539-5.644 2.236zm204.425 7.048c3.619 1.305 10.033 6.213 10.033 7.677 0 .575-1.529 2.63-3.398 4.569-3.347 3.472-3.828 4.518-1.146 2.489 3.124-2.362 4.717-.876 5.015 4.676.24 4.487-.121 5.487-2.72 7.521-1.059.829-1.287.615-2.045-1.917-.47-1.567-1.121-2.683-1.449-2.482s-.12 1.501.458 2.886 1.052 2.61 1.052 2.724c0 .476-5.734 4.703-6.008 4.43-.165-.165-.039-1.949.28-3.966s.34-3.665.048-3.665-.752 1.907-1.023 4.237c-.625 5.389-2.055 6.474-4.38 3.321-2.129-2.884-2.041-3.648.564-4.91l2.179-1.055-2.284-.797c-3.099-1.08-4.349-.952-1.722.177l2.117.909-2.293 1.194c-2.114 1.099-2.463 1.105-4.475.065-1.2-.621-2.338-.973-2.529-.781s.368.73 1.242 1.198l1.59.851-1.706 1.019c-1.05.627-1.196.859-.379.603 1.203-.376 1.282-.134.846 2.597-.264 1.657-.703 3.228-.974 3.492-.525.511-10.121 2.853-10.373 2.532-.082-.105-.004-1.349.173-2.767.418-3.346 3.059-4.167 4.81-1.494.621.948 1.321 1.532 1.555 1.298s.05-.801-.409-1.26c-1.354-1.355-.965-2.504 1.106-3.26 1.166-.426 1.458-.731.734-.764-1.429-.067-7.613-3.689-7.613-4.46 0-.294.716-.534 1.59-.534 2.168 0 11.194-2.625 12.083-3.514.912-.912.853-.907-3.794.33-10.997 2.926-34.071 3.142-44.005.412-6.559-1.802-12.433-4.623-12.433-5.97 0-2.255.939-5.367 1.619-5.367.407 0 1.304-.512 1.995-1.137 1.159-1.049 1.437-1.025 3.603.314 1.291.798 5.33 2.45 8.976 3.671 7.721 2.587 18.182 3.629 27.238 2.712 10.725-1.086 22.646-7.588 20.444-11.152-.527-.852-7.041-3.255-10.261-3.784-1.358-.223-2.119-.256-1.69-.075s.639 1.064.467 1.962l-.312 1.634-11.754-.335c-12.67-.36-20.292.626-27.034 3.497-2.6 1.108-3.595 1.235-4.762.611-.811-.435-1.475-.914-1.475-1.066 0-.719 11.952-4.759 19.804-6.694 16.049-3.955 35.493-5.046 42.825-2.402zm-16.286 6.41c-.179.687-.337.296-.351-.868s.132-1.726.325-1.248.205 1.43.026 2.116zm-13.9 3.027c-1.688 3.153 1.671 3.687 8.572 1.363 4.585-1.545 7.04-1.523 4.132.036-2.459 1.318-12.645 5.018-14.997 5.448-2.612.476-11.208-.478-10.764-1.195.588-.952-1.487-2.206-5.78-3.492l-4.082-1.223 3.718-.903c2.419-.587 4.022-.665 4.586-.223.476.375 1.906.878 3.178 1.119 1.789.339 2.582.122 3.508-.959.913-1.067 2.082-1.397 4.944-1.397 3.542 0 3.706.078 2.985 1.426zm-7.576 1.848c-1.254.528-1.092 2.843.234 3.352 3.121 1.198 6.664-.568 4.798-2.39-.845-.826-3.946-1.418-5.032-.962zm47.515 1.473c-.716.718-1.308-.363-.72-1.314.444-.72.611-.72.849-.003.164.49.105 1.083-.129 1.317zm-4.482 6.049c2.544.712 2.649.864 2.728 3.966.077 2.929.134 3.032.623 1.111 1.018-4.004.843-4.481-1.94-5.254-1.455-.404-2.963-.696-3.351-.649s.485.418 1.94.826zm-9.994 2.193c.796.787 7.701 3.02 7.701 2.491 0-.336-1.645-1.099-3.656-1.696-3.828-1.137-4.531-1.276-4.045-.795zm14.804 11.231c-.534.534-.754-.074-.754-2.092 0-3.701.992-4.699 1.283-1.291.123 1.446-.115 2.968-.529 3.383zm-58.556.553l1.327 1.845-3.292-.615c-1.811-.339-3.544-1.01-3.85-1.493-.687-1.081-.752-4.35-.099-5.002.537-.538 3.884 2.441 5.914 5.265zm7.966-4.957c3.684.011 8.601-.197 10.926-.46 3.92-.443 4.522-.31 8.255 1.827 3.981 2.276 4.008 2.314 2.351 3.233-2.616 1.451-4.034 1.174-7.932-1.551l-3.622-2.531 6.146 5.583-2.367.391c-1.303.216-4.59.42-7.306.453-4.758.058-5.026-.031-7.339-2.426-1.321-1.366-2.578-2.309-2.793-2.093s.706 1.33 2.049 2.476l2.439 2.086-2.822-.007c-2.542-.007-3.167-.402-6.308-3.983l-3.487-3.975 2.555.48c1.406.264 5.571.487 9.255.497zm48.454 5.063c-.718 2.108-3.958 5.288-4.666 4.581-.169-.169.048-1.328.483-2.574s.621-2.436.414-2.644-.801 1.125-1.319 2.96c-.995 3.523-3.387 5.935-6.088 6.138-.853.064-1.551.337-1.551.606s-1.428.975-3.174 1.57c-3.037 1.035-3.926.812-2.525-.631.358-.369.928-1.76 1.267-3.092.523-2.051 1.097-2.577 3.759-3.447 1.728-.565 4.507-1.935 6.176-3.046s3.16-2.02 3.315-2.02 1.17-.828 2.256-1.839c1.936-1.801 1.982-1.808 2.204-.34.125.824-.123 2.524-.551 3.778zm8.49-3.778c6.066 3.058 13.9 7.454 13.404 8.256-.227.368.32 1.016 1.058 1.016 1.261 0 .101 1.552.511 15.692.469 16.209-.083 37.015-.996 37.58-.878.542-48.87 12.573-63.059 15.807l-19.691 4.633c-3.847.956-7.114 1.618-7.26 1.472s-.295-11.929-.33-26.183c-.047-19.58.146-26.045.792-26.444.47-.29 2.599-.918 4.731-1.395s3.702-1.044 3.488-1.258-2.321.02-4.681.52l-4.292.911-14.259-9.734 23.925-.394c21.086-.348 24.847-.584 31.686-1.987 9.766-2.004 18.481-5.663 24.175-10.15 4.823-3.8 5.806-5.134 5.806-7.88 0-.995.168-1.81.374-1.81s2.182-.865 4.618 1.348zm-53.421 1.302c.276.446 1.501 1.523 2.724 2.394s1.996 1.217 1.721.771-1.502-1.523-2.724-2.394-1.997-1.217-1.721-.771zm30.617 1.934c.872 1.348 1.587 2.576 1.587 2.729 0 .248-5.735 1.858-6.617 1.858-.344 0 .132-4.455.659-6.173.515-1.679 2.791-.854 4.371 1.586zm-151.295-.346c4.572.379 9.208 1.151 10.301 1.716 2.479 1.283 6.429 5.71 6.429 7.208 0 2.097-6.236 9.898-9.669 12.096-3.94 2.521-5.834 3.3-12.553 5.159l-4.938 1.367 3.88-.393c4.535-.459 10.697-2.699 13.886-5.047 1.235-.909 2.505-1.662 2.821-1.672s1.648-1.597 2.957-3.527 2.659-3.509 2.998-3.509c.981 0 .717 6.094-.3 6.939-.506.419-1.696.607-2.646.419-1.722-.342-1.722-.342-.114.369 1.556.687 1.571.774.424 2.524-.78 1.191-1.575 1.663-2.318 1.375-.621-.241-2.082-.577-3.246-.748l-2.116-.31 2.116.996c2.513 1.183 2.504 1.607-.066 3.293-1.678 1.102-2.194 1.15-3.761.354-3.344-1.7-5.392-1.877-2.289-.198l3.056 1.652-2.886 1.301c-2.352 1.061-3.217 1.15-4.676.486-2.197-1.001-3.236-1.037-1.547-.054 2.133 1.242 1.373 1.877-3.175 2.65-9.96 1.694-10.526 1.659-13.225-.806l-2.468-2.253 4.141 4.585h-3.521c-3.095 0-3.809-.297-5.903-2.458-1.311-1.352-2.524-2.317-2.697-2.145s.693 1.159 1.922 2.193 2.133 1.981 2.01 2.106-3.191-.054-6.818-.394c-6.265-.588-6.691-.735-8.594-2.959-1.101-1.286-2.015-2.602-2.03-2.924-.068-1.376 4.778.585 7.288 2.95 1.732 1.632 2.456 2.036 1.978 1.104-.414-.807-1.262-1.891-1.883-2.407-.753-.625-.875-1.095-.365-1.41.421-.26-3.136-1.33-7.903-2.377-8.763-1.925-14.894-4.325-17.005-6.656-.975-1.078-1.047-1.932-.468-5.531 1.11-6.891 2.286-9.601 4.265-9.831.945-.11 3.782-.694 6.304-1.298 7.107-1.702 7.682-1.338 2.209 1.4-5.389 2.696-6.931 4.42-5.816 6.504 1.809 3.38 17.163 7.912 26.788 7.906 12.607-.007 30.942-6.479 30.3-10.695-.339-2.23-5.577-5.63-9.326-6.052-2.629-.297-3.239-.156-3.239.743 0 .61.317 1.304.705 1.544s.706.1.706-.311.317-.747.705-.747.706.635.706 1.411c0 1.691.463 1.668-5.424.27-11.227-2.665-28.734-.328-36.369 4.854-1.98 1.344-3.356 1.15-3.356-.474 0-1.438 8.286-5.218 14.263-6.506 5.966-1.286 6.746-2.346 1.444-1.964l-3.362.242 2.822-.691c2.423-.594 16.838-1.633 27.16-1.958 1.746-.055 6.916.21 11.488.589zm103.191 5.462a42.46 42.46 0 0 0-.854-2.373c-.398-.987-.047-1.07 2.645-.624 4.061.672 4.231.808 3.808 3.04l-.36 1.897.768-1.94c1.191-3.003 3.55-2.584 5.008.889l1.182 2.814h-3.08c-1.694 0-3.268-.303-3.498-.674s-.849-.509-1.378-.306-2.262.019-3.85-.409c-2.132-.574-3.001-1.223-3.315-2.476-.749-2.985.497-3.617 1.971-.999.742 1.317 1.171 1.839.953 1.161zm29.938.08c0 2.708-.021 2.729-3.273 3.175-1.799.247-4.164.448-5.253.448-1.981 0-1.981 0-1.069-2.645 1.23-3.568 3.477-3.964 4.578-.806.435 1.248.974 2.086 1.198 1.863s.064-1.049-.356-1.832c-1.01-1.887-.976-2.065.472-2.443 3.248-.848 3.703-.573 3.703 2.24zm-10.147-.715c-1.223 4.42-1.147 4.338-4.007 4.338-2.46 0-2.881-.258-3.734-2.292-.529-1.262-.848-2.5-.709-2.752s2.169-.458 4.512-.458c3.618 0 4.211.175 3.938 1.164zm31.008 1.214c-.259 1.034-.335 2.016-.169 2.183s.515-.544.775-1.578.335-2.016.169-2.183-.515.544-.775 1.578zm-6.046.213c0 .338-.634 2.049-1.408 3.799-1.141 2.579-1.812 3.243-3.527 3.495-2.406.353-2.583-.333-1.127-4.364.569-1.576 1.493-2.621 2.591-2.928 2.492-.697 3.471-.697 3.471-.002zm-177.356 2.559c.635.97 1.644 1.763 2.242 1.763s2.127-.793 3.399-1.763c2.289-1.746 6.181-2.371 6.955-1.119.219.355-.714 1.333-2.075 2.174-2.794 1.726-3.132 2.784-1.062 3.325 2.382.623 1.583 1.529-2.293 2.596-5.848 1.612-8.834 1.967-9.359 1.116-.283-.457-1.329-.58-2.583-.305-1.159.255-4.224.047-6.811-.461l-4.703-.922 5.282-.733c5.9-.819 7.098-2.151 4.12-4.579-1.308-1.068-1.427-1.411-.584-1.689l2.116-.703c2.469-.823 4.248-.392 5.356 1.3zm171.007-1.083c0 .535-1.859 5.064-2.569 6.258-.223.376-5.476 1.476-5.748 1.205-.134-.134.565-1.839 1.554-3.79 1.696-3.347 2.435-3.883 5.881-4.258.485-.053.882.211.882.585zm32.947 1.237c-2.25.59-3.952 1.211-3.782 1.38.316.317 9.049-1.783 9.576-2.303.521-.514-1.607-.175-5.794.923zm-69.803.198c.886 0 .773.374-.533 1.764-2.181 2.322-2.822 2.225-2.822-.428 0-1.709.246-2.098 1.116-1.764.614.236 1.621.428 2.239.428zm29.895.529c-.312.679-1.006 2.266-1.543 3.528-.826 1.938-1.343 2.292-3.348 2.292h-2.372l1.614-2.645c1.249-2.047 1.331-2.418.363-1.639-.687.554-1.713 1.903-2.28 2.998-.829 1.606-1.504 1.992-3.48 1.992-2.809 0-2.85-.084-1.313-2.67l1.139-1.916-1.81 1.94c-1.19 1.276-2.529 1.94-3.908 1.94h-2.098l1.182-2.814c1.118-2.662 1.347-2.815 4.222-2.822 2.229-.005 2.907.228 2.542.875-.398.705-.308.705.452 0 .523-.485 2.236-.914 3.807-.953s3.651-.324 4.621-.635c2.654-.85 2.824-.809 2.21.529zm-24.636.05c1.114.443 1.095.655-.246 2.772-1.434 2.265-3.266 2.853-5.824 1.871-.927-.356-.813-.798.731-2.822 1.805-2.366 2.969-2.763 5.339-1.821zm6.906.455c0 .181-.535 1.451-1.189 2.822-1.054 2.21-1.494 2.493-3.88 2.493-1.48 0-2.691-.2-2.691-.446s.661-1.515 1.469-2.821c1.203-1.948 1.902-2.376 3.88-2.376 1.326 0 2.411.148 2.411.328zm-149.115 2.351c-.757 1.225 1 2.541 3.392 2.541 2.699 0 4.384-1.09 3.613-2.337-.544-.88-6.481-1.053-7.005-.204zM374 422.356c-.889.383-1.019.606-.352.606.582 0 1.693-.272 2.469-.606.889-.382 1.019-.606.352-.606-.582 0-1.693.273-2.469.606zm-4.938 1.411c-.889.382-1.019.606-.352.606.582 0 1.693-.272 2.469-.606.889-.382 1.019-.606.352-.606-.582 0-1.693.272-2.469.606zm24.565 3.069c-7.053 2.007-13.057 3.883-13.345 4.17s.644.521 2.066.521c2.547 0 2.587.043 2.587 2.822 0 1.552-.291 2.822-.648 2.822s-1.15.192-1.763.428c-.889.341-1.116-.083-1.116-2.075 0-2.314-1.332-4.527-1.475-2.451-.306 4.433.289 29.972.708 30.404.716.737 5.404-.311 17.116-3.828l9.648-2.896.447-5.03c.656-7.379.147-28.159-.695-28.364-.388-.095-6.476 1.47-13.53 3.477zm-148.344 6.58l-1.438 1.829v-2.611c0-1.436.374-3.304.831-4.152.806-1.492.85-1.468 1.439.782.49 1.874.329 2.676-.832 4.152zm106.364-4.934c.508.204 1.117.178 1.351-.056s-.182-.401-.925-.37c-.822.033-.989.201-.426.426zm-108.794 5.338c-.604 3.883-2.225 5.229-4.238 3.521-1.38-1.171-1.403-1.171-.477.023 1.137 1.468 1.246 1.331-2.582 3.261-3.185 1.607-3.445 1.521-2.236-.739.42-.784.592-1.596.383-1.805s-.929.772-1.601 2.18c-1.135 2.381-3.906 3.944-7.019 3.96-.811.004-3.544-2.695-3.045-3.007.16-.099 3.021-1.099 6.359-2.223 3.614-1.216 7.751-3.258 10.229-5.047 2.288-1.653 4.28-3.031 4.427-3.064s.057 1.291-.2 2.94zm-57.686 3.073c1.782 2.752 1.676 3.463-.42 2.798-1.255-.399-2.982-3.103-2.982-4.67 0-1.52 1.87-.49 3.402 1.872zm67.288-.346c9.797 5.767 16.658 10.64 17.053 12.111.23.859.424 13.065.428 27.123l.064 13.197-.706 12.736h-.935c-18.794 4.431-45.149 10.084-87.846 18.844-2.045.42-3.856.626-4.023.459s-.475-4.736-.684-10.153c-1.064-27.577-1.801-40.44-2.406-41.994-.368-.944-1.834-2.829-3.258-4.187s-3.693-4-5.043-5.873l-2.455-3.403 12.559.582c6.907.32 18.907.537 26.667.483 13.678-.095 14.333-.167 21.428-2.325 8.296-2.525 12.741-4.607 18.665-8.745 4.392-3.068 7.211-7.297 6.454-9.682-.571-1.801-.35-1.756 4.038.827zm-48.821-1.226c0 .146.556.702 1.234 1.235 1.119.876 1.144.852.267-.267-.922-1.175-1.501-1.549-1.501-.968zm9.646 1.189c.455.558 1.883 1.628 3.174 2.379 1.473.857 2.039.989 1.52.353-.455-.557-1.884-1.628-3.175-2.379-1.473-.857-2.039-.989-1.519-.353zm30.323 5.183c-2.498 2.385-3.185 1.533-1.477-1.829 2.111-4.154 2.722-4.588 3.204-2.274.347 1.67.028 2.43-1.727 4.103zm2.84-4.39c-.225.563-.392.395-.426-.426-.031-.744.136-1.16.37-.926s.26.843.056 1.352zm116.976-.776c-1.164.338-7.947 2.024-15.074 3.746s-13.201 3.394-13.499 3.717c-.702.763.542 30.686 1.308 31.452.321.321 3.571-.066 7.222-.859 6.841-1.486 24.397-6.612 25.119-7.334.695-.695-1.497-31.009-2.255-31.18-.388-.086-1.657.12-2.821.458zm-181.654 4.048c0 .955-3.239 3.703-3.756 3.186-.795-.795-.534-2.923.405-3.301 1.434-.579 3.351-.513 3.351.115zm58.272.541c-.237.618-.625 1.896-.862 2.84-.388 1.548-6.229 5.832-6.958 5.102-.613-.613 4.153-7.809 5.546-8.371 2.243-.907 2.75-.811 2.274.429zm-52.157 3.027l1.838 3.093-3.447-.474c-1.897-.26-4.352-.653-5.457-.871l-2.009-.397 2.35-2.426c1.318-1.359 2.908-2.335 3.619-2.221.697.112 2.095 1.596 3.106 3.296zm7.097-2.357l4.393.458-1.832 2.402c-2.538 3.328-5.813 3.371-8.226.108-2.959-4.002-3.009-4.25-.757-3.816 1.115.215 4.005.597 6.422.848zm26.965 1.345l1.623 1.728-1.676.383c-4.848 1.107-8.007 1.706-8.164 1.55-.096-.097.791-1.349 1.972-2.783 2.512-3.047 4.009-3.257 6.245-.878zm-17.779 1.446c.873 1.348 1.587 2.613 1.587 2.813 0 .521-8.144.449-8.67-.077-.698-.698 3.071-5.205 4.345-5.196.633.005 1.865 1.112 2.738 2.46zm10.259.001c-1.083 1.358-2.605 2.473-3.381 2.479s-2.046.174-2.822.375c-1.088.282-1.778-.284-3.019-2.479l-1.608-2.844h12.8l-1.97 2.469zm19.398-1.235c-.146.292-.938 1.999-1.761 3.795-1.37 2.993-1.853 3.386-5.789 4.715-2.362.798-4.294 1.21-4.294.915s1.099-2.081 2.443-3.971c1.701-2.393 3.361-3.8 5.467-4.636 3.491-1.386 4.305-1.555 3.934-.818zm109.493 2.646c0 1.5-.345 2.472-.882 2.477-.484.004-2.071.204-3.527.445-2.643.436-2.645.435-2.645-2.076 0-2.656.534-2.992 5.114-3.219 1.765-.088 1.94.126 1.94 2.373zm-120.216 2.93c-1.005 1.479-1.827 3.085-1.827 3.569s-.793 1.046-1.763 1.247l-3.528.733c-.97.201-1.763.179-1.763-.05 0-.685 4.187-6.554 5.062-7.095.929-.574 5.047-1.543 5.406-1.272.131.099-.583 1.39-1.587 2.868zm-40.098-1.882c.874.006 1.588.252 1.588.548 0 .521-.401.783-4.483 2.935-2.515 1.325-3.61.317-2.585-2.379.595-1.565 1.059-1.873 2.319-1.536.866.232 2.288.427 3.161.432zm32.222 3.83l-2.537 3.821-4.241.235c-2.333.13-4.356.05-4.496-.177s1.013-1.657 2.563-3.175c2.543-2.49 5.343-3.653 10.711-4.445.295-.044-.605 1.64-2 3.741zm41.675-2.001c-8.055 1.721-19.75 5.121-19.269 5.602.151.151 2.644-.352 5.539-1.12 4.334-1.148 21.391-4.89 22.292-4.89.141 0 .256-.318.256-.706s-.238-.669-.529-.625-4.022.827-8.289 1.739zm-66.788-.498c1.185.751-4.649 5.243-6.091 4.69-.526-.202-1.566-.367-2.31-.367-1.998 0-1.632-.829 1.311-2.972 2.647-1.929 5.363-2.446 7.09-1.351zm8.588.736c0 1.502-5.54 4.998-7.92 4.998-3.573 0-3.742-.739-.754-3.298 2.091-1.79 3.335-2.299 5.676-2.319 1.648-.015 2.998.264 2.998.619zm6.337 2.895l-2.965 3.542-3.626-.463c-1.994-.254-3.766-.585-3.937-.735s.465-.814 1.411-1.473 2.357-1.889 3.133-2.731c1.087-1.18 2.276-1.549 5.18-1.606l3.769-.075-2.965 3.541zm183.543.28c11.274 2.179 15.665 3.385 14.561 4.003-1.826 1.022-19.375 6.285-20.956 6.285-.844 0-1.124-9.996-.303-10.817.629-.629.747-.62 6.698.529zm-138.767 8.208c-5.061 1.104-11.569 2.773-14.462 3.71l-5.259 1.705-.395 6.269c-.627 9.919.095 27.144 1.153 27.55 2.087.801 29.059-5.425 30.011-6.928.635-1.001 1.061-12.817.786-21.761-.257-8.339-.88-12.706-1.8-12.624-.457.041-4.972.976-10.034 2.079zm-47.762 1.841c.485.197 1.279.197 1.763 0s.088-.355-.882-.355-1.366.16-.881.355zm-3.528.706c.486.196 1.279.196 1.764 0s.088-.356-.882-.356-1.366.161-.882.356zm146.911.942c2.91.443 8.624 1.206 12.698 1.696l7.407.891-3.175.879-24.062 6.897c-1.322.388-2.039-2.254-2.039-7.51 0-3.801.333-4.35 2.397-3.947.815.16 3.864.652 6.774 1.094zm-155.2.098c-7.238 1.485-15.808 3.687-15.158 3.896.383.123 5.617-.86 11.631-2.185s9.982-2.398 8.818-2.385-3.545.316-5.291.674zm43.247 5.71c.26 1.934.106 3.169-.436 3.506-.924.577-1.71-1.382-1.824-4.55-.118-3.241 1.805-2.352 2.26 1.044zm-22.083.862c-3.298.896-10.758 2.793-16.577 4.216s-10.824 2.831-11.122 3.129-.159 8.219.31 17.602c.731 14.614 1.011 17.06 1.952 17.056.604-.003 3.797-.656 7.095-1.452s8.803-1.935 12.233-2.53 7.875-1.636 9.877-2.315l3.639-1.233.399-5.58c.421-5.863.1-26.318-.455-29.036-.383-1.879.137-1.889-7.351.143zm-11.993 6.963c0 2.338-.012 2.347-6.311 4.232-8.242 2.467-8.503 2.45-8.503-.552 0-2.285.192-2.49 2.998-3.192a298.15 298.15 0 0 0 6.525-1.734c5.113-1.427 5.291-1.385 5.291 1.246zm50.087 14.878l6.702.859-10.934 2.647-12.169 3.001c-1.081.307-1.235-.192-1.235-4.002v-4.354l5.467.495c3.007.271 8.483.881 12.169 1.354zm-48.676 9.903l13.051 1.656 3.527.508-7.407 1.625-15.329 3.396c-4.357.973-8.24 1.573-8.63 1.332s-.634-2.659-.543-5.411l.164-4.974 2.822.361 12.345 1.507z"
        fill="#000"
      />
      <path
        d="M249.896 145.123c-4.905 2.558-4.804 2.201-4.41 15.585l.356 12.111-3.441 1.43c-1.893.787-3.468 1.845-3.501 2.352s-.011 2.587.051 4.624l.111 3.704h-4.608c-2.534 0-7.081.345-10.103.767-4.579.639-5.791 1.093-7.26 2.72-1.414 1.566-2.604 2.046-5.996 2.421-11.01 1.217-30.249 5.492-43.557 9.681-6.443 2.028-7.098 2.413-10.455 6.161-1.97 2.2-6.417 8.185-9.883 13.303l-6.301 9.305-7.935-3.812c-12.537-6.022-30.738-9.655-35.649-7.116-1.198.62-2.365 1.43-2.595 1.801-.539.871 1.953 12.653 3.738 17.677 2.056 5.788 8.351 20.199 11.02 25.227 1.289 2.429 2.141 4.529 1.893 4.669s-1.721.655-3.273 1.144c-11.622 3.671-23.906 9.997-42.327 21.801-11.136 7.135-13.474 8.922-13.819 10.557-.555 2.633.468 28.984 1.469 37.835.907 8.007.583 10.897-1.421 12.71-1.204 1.09-1.391 2.149-1.354 7.681.061 9.269.753 12.495 3.359 15.657 1.233 1.496 2.242 2.931 2.242 3.187s-2.619 1.173-5.82 2.035c-5.416 1.457-21.21 7.483-30.158 11.504-10.971 4.932-18.818 8.884-19.667 9.907-1.259 1.516-.519 4.378 1.941 7.511 1.067 1.358 3.013 4.056 4.326 5.996s6.505 9.055 11.538 15.81c9.519 12.776 11.83 16.69 13.228 22.41 1.181 4.832 2.313 6.857 7.595 13.584 7 8.915 11.981 14.018 14.451 14.802 7.206 2.289 17.634 3.032 50.536 3.6l40.739 1.056 7.231.477v3.23c0 2.9.495 3.884 4.838 9.632l8.744 11.694c2.147 2.909 5.3 6.847 7.007 8.749l3.101 3.46 9.495-1.559c19.684-3.231 23.874-4.122 51.469-10.955l25.505-6.047c4.133-.876 7.851-1.801 8.263-2.056s.97-3.589 1.238-7.409l.489-6.945 7.472.443c4.11.244 17.314.461 29.342.483 24.138.043 25.335-.116 43.738-5.793 3.88-1.197 13.763-3.856 21.962-5.909 13.984-3.501 31.643-8.225 40.466-10.823 3.371-.992 3.935-1.417 4.326-3.257.635-2.987.706-52.044.077-52.95-.879-1.265-13.006-9.033-16.92-10.838l-3.704-1.708v-5.541c0-6.439-.649-5.894 9.977-8.388 10.199-2.394 10.905-2.809 11.439-6.707.249-1.818.453-7.333.453-12.256 0-8.665-.082-9.152-2.561-15.245l-2.56-6.294-.553-15.52-.68-25.63-.127-10.11-3.093-5.865c-2.673-5.067-2.952-5.983-2.051-6.731.574-.476 1.043-1.223 1.042-1.661-.005-2.445-11.502-20.901-13.02-20.901-1.047 0-3.227-3.165-7.293-10.584l-2.902-5.293.763-5.289c.584-4.045 1.145-5.62 2.388-6.699 1.29-1.12 1.88-2.905 2.855-8.642.677-3.977 1.432-7.231 1.679-7.231 1.905 0 2.947-2.476 4.585-10.894l1.776-9.297c0-.643-15.948-4.333-32.098-7.427l-11.993-2.438c-9.843-2.051-25.04-3.787-33.235-3.798-6.023-.008-7.84.557-20.379 6.339l-4.939 2.276-6.349-.884-12.698-1.742-.209-4.761c-.199-4.557-.304-4.81-2.469-5.938-1.243-.648-3.53-1.563-5.082-2.035l-2.822-.855.23-4.493c.126-2.471.022-6.478-.233-8.904-.576-5.501-2.138-7.224-10.65-11.753l-6.181-3.231c-.053.002-1.048.5-2.211 1.106zm14.848 9.213l1.882 1.744-.253 10.132c-.254 10.155.145 12.367 1.816 10.081.836-1.143 1.12-1.15 4.175-.109 1.803.614 3.492 1.464 3.755 1.89s.66 3.649.883 7.164c.319 5.032.63 6.392 1.463 6.392.582 0 1.164-.748 1.294-1.663.207-1.463.504-1.61 2.466-1.218 5.674 1.135 26.836 3.938 32.218 4.268l5.996.367-8.393-1.746c-4.617-.96-8.545-1.897-8.73-2.081-.349-.349 4.697-2.705 12.479-5.826l4.525-1.815 12.908 1.135c9.456.831 18.62 2.281 34.274 5.421l24.188 5.033 2.822.747-4.233 1.543c-2.328.85-4.867 1.916-5.643 2.372l-1.411.828 1.411.016c.776.009 4.076-.622 7.334-1.403s5.994-1.334 6.082-1.23-.507 3.436-1.32 7.402l-1.478 7.212-3.546 1.52c-1.949.836-4.18 1.983-4.956 2.548-1.292.942-1.159.988 1.587.554 2.612-.414 2.998-.308 2.998.821 0 2.975-2.12 11.119-3.026 11.627-.54.301-1.746 1.189-2.681 1.973-1.323 1.109-1.493 1.561-.766 2.042.559.369.842 1.58.706 3.013-.175 1.824-.523 2.345-1.464 2.187-.678-.113-1.234.134-1.234.55 0 .966 3.61 8.166 7.14 14.242 1.505 2.59 2.736 4.892 2.736 5.115s-1.27.406-2.822.406-2.821.281-2.821.623c0 .875 2.601 1.472 6.462 1.484l3.287.009 4.217 6.879c2.32 3.783 4.738 7.91 5.373 9.17l1.155 2.293h-4.251c-4.939 0-5.574.933-1.253 1.84 2.896.608 3.111.846 6.293 6.99l3.295 6.361.232 10.009c.23 9.872.211 10.02-1.394 10.749-1.837.836-1.464 2.145.611 2.145 1.199 0 1.369.513 1.369 4.122 0 2.266.206 8.409.457 13.651l.457 9.529-2.221.775c-3.103 1.081-2.883 2.489.331 2.115 2.436-.285 2.61-.159 3.882 2.809 2.352 5.487 2.4 6.386.366 6.896-.992.249-2.213.949-2.714 1.556-.807.978-.581 1.059 1.995.716l2.906-.388.449 4.297c.247 2.363.242 7.248-.012 10.855l-.461 6.56-2.541.664-8.306 2.116c-3.171.799-6.234 1.633-6.808 1.853-.776.298-1.167-.335-1.528-2.47-.325-1.922-.849-2.87-1.585-2.87-.94 0-1.033.784-.643 5.397.251 2.969.456 9.185.456 13.815 0 6.418.209 8.349.882 8.128.485-.159.981-1.297 1.102-2.528s.542-2.238.933-2.238c1 0 6.403 3.161 12.435 7.276l5.123 3.494-.37 52.368-4.232.976c-2.328.537-9.312 2.344-15.52 4.016l-24.614 6.317c-7.329 1.802-15.742 4.054-18.694 5.002s-9.766 2.823-15.14 4.164l-9.773 2.439-4.461-3.697c-5.008-4.15-8.798-6.566-8.798-5.608 0 .351 1.92 2.47 4.267 4.708s4.173 4.131 4.057 4.206-11.878.002-26.137-.161l-25.925-.296v-6.935c0-11.915-1.138-8.3-2.075 6.592-.511 8.125-1.213 14.453-1.632 14.714-.405.253-4.101 1.158-8.214 2.011s-16.844 3.88-28.29 6.725c-21.101 5.246-27.858 6.678-45.386 9.617l-9.762 1.636-2.782-3.169c-1.529-1.744-4.261-5.233-6.07-7.755s-5.233-7.125-7.611-10.229l-4.766-6.399c-.244-.415-.944-4.7-1.557-9.523-1.693-13.331-2.328-15.121-2.415-6.814l-.072 6.892-17.46-.363-37.918-.732c-23.021-.416-37.82-1.846-43.529-4.207-1.391-.575-15.353-18.031-16.942-21.182-.587-1.164-1.28-3.294-1.541-4.735-.909-5.02-3.836-10.155-12.182-21.366l-10.079-13.757c-.922-1.358-3.369-4.713-5.438-7.455-3.858-5.116-4.419-6.654-2.88-7.899 1.252-1.013 24.057-11.044 33.527-14.747 7.73-3.023 19.001-6.582 20.844-6.582.501 0 2.476 1.457 4.389 3.239s4.058 3.55 4.767 3.93c1.419.759-5.839-8.595-10.348-13.336l-2.845-2.993-.388-8.53c-.344-7.576-.238-8.768.952-10.644 1.925-3.037 2.477-7.104 1.746-12.852-.797-6.256-1.884-22.483-2.133-31.828l-.188-7.055 3.85-2.567c18.155-12.103 33.541-20.6 46.428-25.639l8.59-3.36 2.898 3.292c4.959 5.634 4.225 3.145-2.478-8.399-4.251-7.319-11.769-25.18-13.812-32.814-.883-3.298-1.908-6.772-2.278-7.721-.555-1.426-.389-1.945.963-2.999 1.841-1.437 5.056-1.305 15.038.611 10.861 2.086 19.187 5.745 36.683 16.125 14.966 8.879 15.652 9.628 25.981 28.389 4.3 7.81 9.216 15.466 12.107 18.857l1.805 2.116-1.666-3.174-4.956-9.28c-1.809-3.358-3.289-6.426-3.289-6.819 0-.721 11.246-3.654 14.007-3.654 1.358 0 1.451.287 1.085 3.351l-.401 3.351 1.923-3.175c2.401-3.964 6.413-8.263 8.954-9.597 2.22-1.166 8.128-.498 12.68 1.431 1.443.612 2.95 1.112 3.351 1.112 1.275 0 .782-2.038-.683-2.822-1.201-.643-1.411-1.477-1.411-5.593 0-4.674-1.679-22.678-2.557-27.409l-.43-2.314 2.905.465c2.359.377 2.904.258 2.904-.637 0-1.313-.24-1.388-10.484-3.3-4.408-.822-10.44-2.247-13.404-3.167a356.25 356.25 0 0 0-11.032-3.182c-3.104-.831-9.12-2.65-13.368-4.041-5.042-1.652-7.816-2.258-7.987-1.746-.143.431-3.925 5.955-8.401 12.274s-8.459 12.17-8.847 13c-.676 1.448-.789 1.462-2.739.353-1.119-.637-2.036-1.49-2.039-1.897-.005-.828 9.278-14.705 13.989-20.913 2.911-3.837 3.336-4.112 9.517-6.148 7.697-2.536 17.858-5.236 25.166-6.689 18.457-3.669 23.173-4.081 35.625-3.11 5.922.463 6.16.431 3.528-.462-1.552-.527-5.141-1.351-7.975-1.832s-4.882-1.146-4.553-1.475c.791-.791 6.895-1.799 14.064-2.324 5.605-.411 5.776-.377 5.996 1.177.125.88.704 1.599 1.286 1.599.839 0 1.02-.839.875-4.056-.101-2.231-.005-4.056.212-4.056s1.351.494 2.52 1.1 3.08 1.001 4.247.881l2.121-.218-2.695-1.381c-3.679-1.886-6.575-3.893-6.575-4.556 0-1.061 5.469-2.774 6.277-1.966 1.69 1.69 1.854.303 1.078-9.127l-.472-5.743 6.873.666-3.174-1.931-3.263-1.997c-.048-.037-.308-1.883-.577-4.104-.485-4.002-.47-4.049 1.808-5.434l2.297-1.397 5.47 2.846c3.008 1.565 6.316 3.631 7.351 4.59zm-75.84 61.285c7.195 2.059 15.663 4.298 18.817 4.976 4.645.998 5.814 1.513 6.152 2.711.511 1.812 2.416 19.056 3.003 27.168.407 5.633.36 5.909-.913 5.409-2.143-.843-8.454-1.343-10.491-.832-1.028.258-3.198 1.673-4.825 3.144-2.627 2.379-3.605 2.773-8.777 3.54-3.203.476-7.585 1.446-9.738 2.156-3.909 1.29-3.918 1.289-4.84-.213-.509-.827-2.766-4.679-5.018-8.559-4.831-8.327-9.587-13.21-16.943-17.395-2.892-1.645-5.258-3.197-5.258-3.449 0-.508 15.063-22.211 16.698-24.059.956-1.08 1.322-1.062 5.041.248 2.205.777 9.897 3.097 17.092 5.155zm78.627 7.082c-13.259 1.703-24.056 1.95-32.046.734-8.534-1.299-10.887-1.395-10.284-.418.383.62 2.57 12.086 3.657 19.183.254 1.653-.067 3.896-.879 6.156-1.228 3.414-1.135 4.889.254 4.031.36-.222 1.677-2.556 2.928-5.185 2.756-5.792 10.542-19.112 11.531-19.722 1.063-.657 10.377-1.122 10.377-.518 0 .287-1.698 3.566-3.774 7.285-4.193 7.516-7.325 14.048-10.461 21.821-2.212 5.48-2.392 7.732-.236 2.951 1.428-3.167.87-2.99 13.413-4.261 4.268-.432 13.11-1.55 19.651-2.483 10.77-1.538 12.124-1.6 14.371-.661 3.019 1.261 3.056 1.262 2.617.117-.194-.506-1.241-1.444-2.326-2.085-1.611-.952-2.339-2.372-3.961-7.723-1.093-3.606-2.906-8.899-4.029-11.761-1.872-4.771-1.949-5.306-.927-6.436 1.027-1.135.988-1.265-.501-1.664-.889-.238-1.774-.396-1.968-.35s-3.527.49-7.407.989zm8.869 9.52c3.296 9.026 5.205 15.407 4.747 15.866-.74.739-38.571 5.553-39.171 4.984-.387-.367 14.142-25.949 14.903-26.241 1.044-.4 15.349-2.251 16.208-2.097.34.061 1.831 3.431 3.313 7.488zm-41.609-6.271c2.706.447 4.831 1.01 4.721 1.252s-1.945 3.35-4.079 6.906c-4.321 7.2-4.254 7.214-5.605-1.211-.467-2.91-1.006-5.846-1.197-6.525-.412-1.46-.211-1.474 6.16-.422zm72.375 7.124c.224 1.455.286 2.642.139 2.639s-3.737-.464-7.976-1.023c-8.014-1.058-8.871-.987-8.871.739 0 1.898 3.648 9.768 6.05 13.052 2.35 3.211 2.417 3.244 8.172 4.057 3.191.452 6.059 1.217 6.372 1.701.919 1.421 1.947-.818 1.524-3.32-.839-4.95-3.999-17.095-4.873-18.727-.906-1.69-.928-1.654-.537.882zm12.521-1.235l1.133 5.644c1.087 5.537 5.528 20.269 6.37 21.128.409.418.657.086.657-.882 0-1.883.028-1.883 9.211-.207 6.611 1.207 18.157 2.869 22.358 3.217.874.072 2.302.774 3.175 1.56s2.063 1.689 2.645 2.007c1.693.927-.955-2.031-11.277-12.596-12.788-13.089-23.004-22.078-15.97-14.051 1.662 1.897 1.963 1.869-8.202.768-4.412-.478-7.606-1.143-7.636-1.588-.029-.422-.663-2.037-1.41-3.589s-1.221-2.187-1.054-1.411zm-18.657 5.531l6.691.867 2.278 12.433-3.951-.474c-7.197-.861-7.039-.748-10.023-7.235-1.51-3.284-2.745-6.098-2.745-6.254 0-.353-.264-.376 7.75.663zm39.977 4.897c.899.091 4.485 3.283 8.788 7.823l7.267 7.67-4.555-.483c-5.025-.534-24.856-3.882-25.235-4.261-.131-.131-.8-2.411-1.486-5.064l-1.709-6.261c-.457-1.422-.389-1.427 7.474-.507l9.456 1.083zM127.322 278.81c-1.706.993-1.546 2.06.308 2.06.848 0 2.99 1.22 4.762 2.71 10.947 9.214 22.841 14.946 35.367 17.045 4.282.718 5.725 1.314 7.889 3.26 1.456 1.31 2.812 2.381 3.012 2.381s-.243-1.19-.986-2.645c-1.726-3.38-8.489-9.835-14.112-13.469-13.771-8.901-31.113-14.328-36.24-11.342zm17.342 4.564c5.815 2.031 16.083 7.665 21.476 11.784 2.047 1.563 3.621 2.942 3.499 3.064s-2.308-.214-4.857-.747c-9.357-1.958-21.596-8.121-28.818-14.51l-2.469-2.185 3.066.417c1.687.23 5.334 1.209 8.103 2.177zM383.93 428.951l-3.527 1.238-.213 4.453c-.117 2.449-.015 4.963.227 5.586.401 1.033.512 1.034 1.27.012.458-.616 1.785-1.434 2.949-1.819 1.927-.637 2.134-1.011 2.324-4.194.165-2.772.52-3.635 1.718-4.177.83-.375 1.636-1.079 1.791-1.564.389-1.224-2.263-1.035-6.539.465zm.926 5.173c-.145 1.506-.642 2.366-1.455 2.52-.989.188-1.235-.267-1.235-2.287 0-2.076.257-2.521 1.456-2.521 1.217 0 1.419.376 1.234 2.288zm-44.311 7.905l-5.291 1.629.214 3.789c.225 4.009 1.182 5.921 1.954 3.907.249-.647.973-1.178 1.611-1.18s2.35-.334 3.805-.739c2.481-.689 2.645-.905 2.645-3.498 0-2.1.362-2.957 1.506-3.57 1.204-.644 1.31-.93.529-1.425-1.212-.768-.686-.85-6.973 1.087zm2.116 2.448c0 .356.177 1.107.392 1.668.279.729-.426 1.228-2.469 1.746-2.841.721-2.861.712-2.861-1.268 0-1.635.351-2.047 1.94-2.289l2.469-.399c.291-.059.529.186.529.542zm-105.818 19.436c-2.134.491-4.781 1.255-5.882 1.698l-2.003.805.498 6.167c.274 3.391.744 7.436 1.044 8.988l.545 2.822.087-3.175c.137-4.992.685-6.218 3.01-6.728 2.043-.449 2.088-.551 1.91-4.386l-.181-3.928 3.484-1.591c3.919-1.789 3.192-1.984-2.512-.672zm-3.266 4.783c.656 2.448.534 3.166-.613 3.607-.832.318-1.059-.196-1.059-2.394 0-3.043.989-3.76 1.672-1.213zm-29.537 3.793l-5.291 1.03c-5.002.971-13.479 3.544-14.722 4.47-1.138.847-.703 8.544.554 9.801.549.55.765.35.765-.709 0-1.134.586-1.583 2.543-1.95 4.634-.87 11.485-3.228 12.592-4.335.6-.599 1.09-2.127 1.09-3.397 0-2.083.276-2.39 2.842-3.159 1.563-.467 2.655-1.153 2.428-1.522s-.635-.634-.903-.589-1.122.207-1.898.36zm-5.291 5.219c0 1.571-1.268 2.212-8.299 4.196l-4.418 1.246-.428-1.704c-.235-.938-.311-1.803-.167-1.924.478-.402 10.823-3.132 12.078-3.188.787-.034 1.234.464 1.234 1.374z"
        fill="#323239"
      />
      <defs>
        <clipPath>
          <path
            d="M0 0h525.111v525.111H0z"
            fill="#fff"
            transform="translate(30.889)"
          />
        </clipPath>
      </defs>
    </svg>
  );
};
GlowErrorCarSvg.displayName = 'GlowErrorCarSvg';
