import type { FC } from 'react';

// istanbul ignore next: trivial
export const GlowReportChannel: FC = () => {
  return (
    <svg
      fill="none"
      height="100%"
      preserveAspectRatio="xMidYMid meet"
      role="img"
      viewBox="0 0 260 260"
      width="100%"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#A)">
        <path
          d="M141.413 20.235c-.017.017-1.629.066-3.583.11l-4.691.14-2.725.132-6.312.351-2.104.134-1.863.143-1.828.138-2.035.169-1.38.105c-.227.001-.522.031-.655.067s-.722.097-1.311.135l-2.242.213-2.207.242-3.421.412c-.092.022-.477.069-.856.105l-1.621.207-1.69.237-1.828.272-1.587.254-3.537.586c-.295.056-.639.102-.766.102a1.58 1.58 0 0 0-.43.069c-.11.038-.728.161-1.373.273l-2.725.512c-.057.022-.336.072-.621.11a15.11 15.11 0 0 0-1.138.213l-1.173.24-1 .202-2.277.492-.931.198-1 .215-.69.175c-.095.035-.405.108-.69.163l-1.552.367a14.4 14.4 0 0 1-.931.222l-.862.216c-.076.034-.278.089-.448.123l-.862.211-1.966.515-.862.234-1.242.351-6.174 1.884-1.207.399c-.166.049-1.093.375-1.621.57l-.414.138-.828.286-.724.257-2.149.787c-.12.056-.277.102-.351.102s-.154.02-.178.045c-.047.047-.441.193-1.289.478l-.652.249c-.074.041-.415.177-.759.301l-2.429.967a1.15 1.15 0 0 1-.287.101c-.038 0-.302.109-.585.242s-.549.242-.591.242-.301.105-.577.232l-.897.378-.517.214a7.16 7.16 0 0 1-.467.215l-.621.269-.552.244-.7.32-.464.199c-.022 0-.437.189-.921.421l-1.537.733-1.406.683-.845.372c-.052 0-.095.023-.095.052s-.163.125-.362.214l-2.742 1.374-3.346 1.741-2.104 1.086-1.621.844c-.038.03-.146.078-.241.107s-.281.125-.414.212c-.226.149-.657.388-1.484.823-.19.1-.394.226-.454.28s-.138.098-.173.098-.306.155-.602.345l-.586.347c-.026.001-.234.125-.46.276s-.449.274-.494.274-.092.023-.105.052a2.14 2.14 0 0 1-.665.431c-.045 0-.083.023-.083.052s-.147.144-.328.256l-.362.242c-.019.021-.174.128-.345.238a11.58 11.58 0 0 0-.734.534l-.459.335c-.153 0-2.257 2.091-2.257 2.243 0 .02-.103.183-.228.363a11.41 11.41 0 0 0-.457.73c-.215.378-.54.666-.755.666-.052 0-.285.115-.517.255-2.684 1.614-4.021 5.059-3.558 9.166.107.95.098 1.496-.036 2.243-.286 1.587-.162 3.218.417 5.486.257 1.004 1.056 3.461 1.242 3.818.053.101.096.232.097.291s.025.136.056.172.128.252.216.48l.365.863.377.863.845 1.919.28.632a10.18 10.18 0 0 0 .249.565l.825 1.818c.197.449 2.044 4.133 2.56 5.107l.987 1.829.294.523.402.685c.022.019.134.205.247.414l.441.759c.021.019.164.252.318.518l1.265 2.137c.223.348.483.816.483.868 0 .03.025.065.056.078s.163.205.293.427l.357.587a4.08 4.08 0 0 1 .206.355.68.68 0 0 0 .173.228c.048.03.088.084.088.12 0 .061.217.406 1.406 2.24l.561.876c.113.194 1.423 2.127 1.775 2.619.18.252.328.49.328.529s.023.081.052.094.145.163.258.333l.242.346c.019.019.128.174.241.345l.719 1.035.934 1.345.751 1.07 1.08 1.57c0 .047.024.086.053.086s.192.189.362.419l.381.501c.04.044.257.328.483.631l.514.66c.195.209.448.517.651.792a1.85 1.85 0 0 0 .293.331c.05.03.09.097.09.149s.028.105.061.117.259.256.5.541c.926 1.091 1.306 1.473 2.094 2.105.705.565 1.22.892 2.035 1.289 1.174.573 1.375.643 2.575.89.88.182 2.659.183 3.53.002 1.098-.229 1.435-.343 2.518-.855a9.02 9.02 0 0 0 1.697-1.023c.193-.148.379-.269.413-.269.055 0 1.684 1.629 1.684 1.684a9.52 9.52 0 0 0 .5.539l2.745 2.884 5.991 6.211 1.456 1.638c.001.084-.043.271-.096.414-.205.549-.335 1.553-.296 2.3.044.87.201 1.86.397 2.515l.227.793a2.52 2.52 0 0 0 .168.462.65.65 0 0 1 .085.226c0 .064.557 1.277.778 1.693l.82 1.438.333.604c0 .035.024.063.053.063s.111.107.181.238.179.295.24.363.204.263.316.434l.535.741.33.468c0 .022.065.108.145.192s.217.261.305.394a5.76 5.76 0 0 0 .336.448l.23.278c.029.04.185.232.346.427s.293.373.293.394.054.097.121.166.276.319.466.556l.483.588.379.456.755.891.655.758.452.508.473.524c1.632 1.82 8.299 8.49 8.495 8.499.019 0 .288.241.597.535l1.161 1.086.785.724a12.95 12.95 0 0 0 .425.371c.131.108.395.341.586.517a21.34 21.34 0 0 0 .861.732l.625.518c.161.151.721.619 1.202 1.004l.628.51c.352.292.464.379.717.555.133.092.315.238.405.325s.478.393.862.68l.86.657c.089.074.188.135.221.135s.085.041.115.091.319.272.642.493a26.38 26.38 0 0 1 .828.587c.133.102.491.357.797.567l.931.646a99.5 99.5 0 0 0 2.433 1.653c.237.152.631.417.877.588s.586.398.757.502l.441.274 1.849 1.187c.353.226.652.435.665.465s.063.055.113.055.276.124.503.276.445.276.485.276.082.024.095.053.194.162.403.294l1.085.665c.238.143.432.284.432.314s.028.055.062.055c.054 0 .572.292 1.238.698l2.459 1.47c.57.311.967.554.989.607.013.03.057.054.098.054s.124.043.184.096.28.183.488.29.395.211.414.233.112.078.207.126.297.161.449.253.426.248.611.348.665.377 1.069.615l.837.478c.195.086.862.474 1.159.674.164.11.313.2.332.2s.33.17.692.379.675.38.698.38.089.042.149.094.249.172.42.266l.586.331.414.236c.076.042.269.161.43.265s.32.188.355.188.217.104.406.23a3.77 3.77 0 0 0 .45.272c.059.023.242.128.406.233a9.9 9.9 0 0 0 .643.371 13.56 13.56 0 0 1 .621.347c.152.093.361.215.464.272.886.487 1.404.784 1.433.82.044.055.349.227.816.461.203.101.528.289.723.418s.381.233.413.233.194.094.359.207.327.208.359.208.223.108.425.241.38.242.397.242c.053 0 2.873 1.661 3.294 1.94.222.147.447.268.5.268s.095.031.095.069.033.069.073.069.327.166.638.369.798.506 1.083.672.528.326.54.355.052.053.087.053.219.109.408.242.372.241.408.241.108.043.161.096.264.194.47.315a33.96 33.96 0 0 1 .823.501c.567.358 1.441.856 1.971 1.124.225.114.42.23.432.259s.06.052.104.052.298.108.563.24.505.241.533.242c.049.001.749.299.95.405.152.08 1.124.331 1.761.454.815.159 2.348.144 3.23-.031.754-.15 1.625-.398 1.732-.493.036-.032.104-.058.151-.058.121 0 1.577-.72 1.68-.831a5.43 5.43 0 0 1 .372-.257c.543-.355.923-.686 1.767-1.54.942-.954 1.292-1.385 1.974-2.432.323-.496 1.027-1.942 1.232-2.531.35-1.007.42-1.272.757-2.887.058-.278.125-.946.15-1.484s.075-1.017.113-1.064c.091-.116 1.502-2.937 1.665-3.33.291-.701.545-1.281.705-1.61.052-.107.095-.226.095-.263s.058-.197.129-.356c.134-.3.644-1.595 1.079-2.74.526-1.383.451-1.277 1.207-1.721 1.244-.731 1.999-1.441 3.307-3.109l.621-.773c.122-.134.165-.189.45-.573.112-.152.236-.312.276-.355a4.18 4.18 0 0 0 .205-.263 6.45 6.45 0 0 1 .258-.329c.069-.079.126-.162.126-.185s.087-.134.193-.248.329-.394.496-.621l.376-.498c.124-.143.202-.246.553-.727.187-.257.365-.466.395-.466s.056-.028.056-.063c0-.077.988-1.4 1.14-1.526.098-.081.105-.069.063.11a3.4 3.4 0 0 1-.132.409c-.214.524-.381.974-.381 1.026 0 .032-.044.155-.096.275-.102.231-.28.749-.394 1.149a4.24 4.24 0 0 1-.128.38 3.86 3.86 0 0 0-.139.448l-.157.587c-.042.152-.079.773-.082 1.38-.004.998.012 1.154.167 1.622.636 1.923 2.032 2.967 3.967 2.967.92 0 1.749-.218 2.632-.694.434-.234 1.12-.706 1.411-.971a41.61 41.61 0 0 1 .586-.518c1.174-1.022 2.56-2.408 4.268-4.269.104-.114.334-.375.51-.581a15.39 15.39 0 0 1 .428-.483c.059-.06.354-.403.655-.762l.651-.767c.257-.285.474-.54.76-.892.169-.209.327-.395.351-.414s.291-.345.594-.725.634-.777.734-.884.183-.209.183-.229c0-.035.548-.719.629-.785.023-.019.331-.405.684-.857s.699-.879.768-.949.127-.149.128-.178.109-.176.241-.328l.292-.345.354-.475c.166-.223.352-.46.414-.527s.233-.295.382-.508.297-.388.328-.388.057-.032.057-.071c0-.058.185-.32.607-.86.029-.038.316-.426.636-.863s.606-.804.635-.816.053-.057.053-.098.049-.124.108-.184c.106-.109 1.301-1.741 1.94-2.653a9.32 9.32 0 0 1 .453-.603c.066-.073.121-.15.121-.173s.116-.191.258-.372.306-.398.363-.482.175-.251.264-.37.536-.746.994-1.391l1.084-1.519.843-1.173.853-1.208c.336-.474.932-1.344 1.324-1.932l.797-1.193c.046-.067.26-.393.476-.724s.425-.639.466-.685.073-.103.073-.126.166-.282.369-.575.381-.563.396-.599.335-.532.71-1.101l.863-1.311c.099-.152.203-.287.232-.299s.051-.053.051-.089.16-.305.355-.598l.921-1.409c.038-.065.232-.359.431-.656l.806-1.228a14.84 14.84 0 0 1 .517-.774c.041-.045.075-.099.075-.118s.12-.215.267-.434l.533-.813c.147-.228.292-.446.323-.483s.286-.426.566-.861l.58-.897.835-1.286c0-.016.108-.183.241-.373s.242-.36.242-.381.032-.076.072-.122.208-.3.375-.566.328-.514.359-.552c.099-.122.653-.975.882-1.36l.546-.898 1.207-2.008.836-1.391c.267-.418.689-1.159.689-1.211 0-.032.04-.099.089-.149s.506-.801 1.017-1.667l1.081-1.829a12.07 12.07 0 0 0 .227-.391c.146-.267.249-.435.321-.527.041-.052.175-.28.297-.508s.248-.445.278-.483a231.51 231.51 0 0 0 2.128-3.623c.208-.361.397-.671.42-.69.061-.052.268-.423.356-.639.043-.104.106-.19.14-.19s.062-.044.062-.098a.33.33 0 0 1 .087-.19c.048-.05.125-.169.172-.264a3.43 3.43 0 0 1 .152-.276c.036-.057.196-.321.354-.586l.453-.759c.091-.152.199-.362.239-.466s.1-.19.132-.19.079-.07.105-.155a.89.89 0 0 1 .133-.259c.048-.057.164-.243.258-.414s.238-.419.319-.552.186-.319.233-.414a1.03 1.03 0 0 1 .125-.207c.022-.019.08-.136.13-.259s.111-.224.137-.224.081-.085.126-.19a7.57 7.57 0 0 1 .324-.604c.134-.228.289-.507.345-.621.095-.192.235-.45.878-1.622l1.006-1.874c.067-.127.137-.246.156-.265s.122-.205.229-.414a38.12 38.12 0 0 1 .462-.863l.372-.69c.057-.114.232-.44.388-.725l.465-.863c.099-.19.198-.361.219-.38s.123-.205.228-.414c.231-.461 1.12-2.124 1.586-2.968l.448-.827.536-1.001.551-1.035.517-.966.935-1.751.683-1.286.893-1.725c.27-.531.509-.982.532-1.001s.066-.109.095-.2.137-.312.242-.49.214-.399.242-.49.075-.197.105-.235c.049-.065.581-1.111.998-1.967.206-.422.263-.524.538-.95.25-.387 1.772-2.321 1.851-2.351.033-.013.061-.067.061-.121s.028-.098.063-.098.126-.101.202-.224.197-.286.267-.362.573-.713 1.118-1.415 1.033-1.311 1.085-1.353.093-.095.093-.117.345-.485.768-1.028.842-1.105.933-1.248a3.31 3.31 0 0 1 .284-.386c.066-.069.15-.172.188-.231s.365-.511.728-1.006l1.165-1.601.471-.656.452-.638.991-1.415.884-1.273c.166-.267 1.075-1.649 1.126-1.712.031-.038.146-.225.255-.414s.216-.359.238-.378a1.06 1.06 0 0 0 .127-.207c.125-.246.248-.454.334-.562.041-.052.16-.249.265-.439l.747-1.38c.079-.152.163-.292.189-.311s.069-.109.098-.2.141-.318.25-.503.199-.355.199-.376.171-.393.38-.828.379-.806.379-.825c0-.032.095-.255.378-.891.051-.114.16-.44.242-.725s.176-.58.209-.656c.13-.301.344-1.923.344-2.606 0-.747-.197-1.961-.384-2.373-.054-.12-.099-.245-.099-.279s-.112-.277-.249-.541a4.71 4.71 0 0 0-1.361-1.642 6.26 6.26 0 0 1-.276-.223c-.345-.313-1.85-.859-2.368-.859-.136 0-.208-.096-.441-.587l-.278-.587-.516-.242c-.284-.133-.535-.241-.558-.241s-.171-.06-.326-.133c-.634-.296-.916-.42-.96-.42-.025 0-.238-.093-.473-.207s-.465-.207-.51-.207c-.071 0-.271-.079-1.031-.41-.076-.033-.34-.131-.587-.219s-.526-.199-.621-.248-.214-.089-.265-.09c-.087-.001-.225-.054-.838-.326-.133-.059-.335-.132-.449-.163a14.15 14.15 0 0 1-1.172-.401c-.271-.121-.766-.283-.865-.284-.056 0-.179-.041-.274-.09s-.405-.161-.689-.249l-1.208-.387c-.379-.125-1.015-.325-1.414-.444l-1.173-.35-1.345-.384-1.293-.381c-.219-.072-.452-.13-.518-.13a2.08 2.08 0 0 1-.431-.1 18.25 18.25 0 0 0-.896-.248l-.922-.245c-.185-.053-.382-.097-.438-.097s-.309-.058-.561-.129c-.621-.175-1.087-.29-1.46-.36a7.63 7.63 0 0 1-.552-.128c-.276-.079-1.159-.283-1.966-.454-.303-.064-.721-.163-.928-.219s-.611-.143-.897-.194a18.37 18.37 0 0 1-.968-.201 20.99 20.99 0 0 0-1.001-.21l-1.379-.27-1.622-.319-1.103-.217c-.365-.08-1.584-.311-2.168-.41-.225-.038-.438-.087-.473-.109s-.332-.082-.66-.133l-2.114-.365c-.305-.074-1.11-.219-3.312-.596l-2.69-.482a17.64 17.64 0 0 0-1.104-.174 13.74 13.74 0 0 1-.897-.136 47.1 47.1 0 0 0-2.207-.38 74.32 74.32 0 0 1-2.277-.371c-.227-.041-.646-.108-.931-.147l-1.234-.171c-.394-.055-.813-.129-.931-.164s-.432-.084-.698-.107-.638-.072-.827-.109c-.63-.122-2.538-.396-4.018-.576-.464-.057-.899-.119-.966-.14-.154-.046-1.525-.232-2.605-.353l-1.931-.238-2.035-.245-3.277-.377a13.48 13.48 0 0 0-1.035-.105 21.57 21.57 0 0 1-1.138-.105c-1.416-.181-2.899-.321-5.829-.552a70.63 70.63 0 0 1-1.759-.167c-.512-.056-1.257-.119-1.656-.141s-1.066-.07-1.483-.107a89.9 89.9 0 0 0-1.966-.14l-1.414-.101c-.114-.015-.937-.06-1.828-.1l-2.622-.14c-.55-.037-1.869-.101-2.931-.14l-3.45-.139c-2.9-.128-7.407-.224-11.903-.252-2.487-.015-4.536-.015-4.553.002z"
          fill="#9146ff"
          fillRule="evenodd"
        />
      </g>
      <g clipPath="url(#B)">
        <g clipPath="url(#C)">
          <path
            d="M80.506 68.027c-2.264.034-4.458.969-6.923 1.926-.738.286-1.568-.08-1.854-.817s.08-1.568.817-1.854c2.263-.878 5.017-2.076 7.916-2.119 9.795-.148 20.219-.792 29.804 1.297 4.013.875 8.139 1.025 12.178 1.745 3.591.64 6.636 2.572 10.094 3.325 1.983.432 4.727 2.514 5.395 4.57.265.814.173 1.721.067 2.553-.27 2.114-.388 4.272-.745 6.372-.658 3.874-.108 8.319-.108 12.289 0 3.877-3.547 13.143-.121 15.858 1.137.902 2.548 1.711 3.24 3.039 1.09 2.091-1.3 3.391-.172 7.232.352 3.068-.335 5.77-.726 8.748-.232 1.774-1.496 2.728-2.82 3.78-.107 1.9-.409 3.757-.433 5.674-.035 2.764.158 5.548-.217 8.295-.271 1.986-.423 3.98-.632 5.973-.33 3.143-.424 6.234-.416 9.388.005 1.888-.069 4.083-2.133 4.951-1.472.618-3.01 1.079-4.458 1.755 1.367 1.975 1.659 3.979.976 6.234-.137.452-.643 1.481-.172 1.881 1.177.999 3.005.911 4.387 1.513.626.273 1.265.597 1.868 1.061.504-.908.861-1.882 1.469-2.732-.254-.341-.659-.657-1.301-1.154l-.016-.012c-.591-.457-1.421-1.098-1.959-1.995-.336-.561-.736-1.307-.526-2.223.403-1.761 1.717-3.71 2.534-5.346.569-1.14 1.245-2.54 2.406-3.199 2.187-1.242 6.055 1.561 9.945 3.106.487-.628.591-1.561.743-2.321.405-2.029 1.253-3.897 1.935-5.836l9.393-27.187c2.589-7.016 4.493-14.684 7.579-21.444 1.73-3.787 3.132-8.418 7.496-9.894 4.18-1.413 8.555-3.509 12.271-5.852 2.359-1.487 4.71-2.752 7.169-4.091.531-.289 1.411-.649 2.289-.22s1.082 1.327 1.146 1.696c.988 5.721 2.679 11.596 2.679 17.409 0 1.882-.149 3.81-.253 5.689-.036.647-.157 1.424-.578 2.166-2.363 4.173-4.985 8.009-7.493 12.033-4.718 7.57-9.09 15.677-13.581 23.321-3.835 6.526-8.601 12.677-12.256 19.129-.433.764-.749 1.557-1.078 2.457.641.182 1.295.311 1.907.586 2.016.903 5.696 2.671 7.829 2.917 1.424.165 2.028 1.55 1.599 2.81-.226.661-.679 1.326-1.018 1.659-2.608 2.557-3.329 6.708-5.94 9.526l-4.088 4.352c-.532.55-1.049 1.16-1.796 1.417-.838.287-1.725.057-2.552-.154-2.156-.547-6.571-2.081-6.571-2.081-.405 3.557-2.959 6.659-5.061 9.423-.262.345-.871 1.046-1.884 1.073-1.582.043-3.184-.196-4.758.023-.351 1.427-1.149 2.536-1.665 3.893 1.211.487 2.525.922 3.266 2.085.475.745.541 1.671-.011 2.398-.855 1.124-2.331 1.975-3.391 2.895-1.908 1.656-4.914 4.999-7.675 4.999-1.541 0-2.981-.159-4.471-.555-.195.67-.517 1.291-.785 1.934.688.653 1.468 1.201 2.157 1.855.784.744 1.052 1.648 1.052 2.722 0 3.431-1.099 6.727-1.292 10.137-.049.87.265 1.707.9 2.569.874 1.186 2.005 2.069 3.18 2.929.804.588 1.698 1.329 1.868 2.37.147.9-.347 1.716-1.12 2.15-1.473.825-3.07 1.247-4.475 1.63-1.085.296-2.076.567-3.033.969-.729.306-1.569-.037-1.876-.766s.037-1.569.766-1.876c1.146-.481 2.341-.806 3.418-1.099 1.098-.299 2.064-.568 2.933-.937-1.441-1.101-2.878-2.191-3.968-3.67-.891-1.21-1.552-2.692-1.454-4.431.19-3.352 1.287-6.608 1.287-9.975 0-1.551-2.611-2.245-3.201-3.675-.594-1.441.977-2.547.95-3.95-1.621-1.64-4.131-1.854-5.218-4.125-.717-1.498.231-2.677.261-4.168-1.714-.999-3.519-2.201-5.338-2.994-.411-.179-.854-.268-1.249-.485-.824-.452-1.208-1.311-1.156-2.23.168-2.961.577-6.002 1.144-8.918.228-1.171.809-2.546 2.22-2.546 1.403 0 2.566 1.094 3.346 2.157 1.512 2.059 7.772.371 10.075.371 2.614 0 4.829.641 7.29 1.331.833.233 1.063.963 1.115 1.245.507 2.754-1.368 7.034-2.479 9.431-.391.844-1.087 1.301-1.705 1.565-1.135.486-3.089.324-3.909 1.307-.597.716-2.2 4.519-1.828 6.172 1.451.493 3.072.691 4.595.691.609 0 1.236-.7 1.702-1.017 2.303-1.563 4.284-3.533 6.449-5.271-.654-.398-1.44-.496-2.092-.907-.925-.582-1.368-1.615-1.125-2.686.366-1.615 1.329-3.973 2.212-5.322.243-.372.662-.788 1.315-.93 1.002-.219 2.085-.234 3.045-.214l2.369.06c1.87-2.655 4-5.223 4.535-8.528.061-.374.178-1.012.521-1.515.546-.802 1.556-1.049 2.427-.644 2.419 1.123 5.336 2.268 8.015 2.551 1.707-1.495 3.146-3.293 4.685-4.954 2.638-2.848 3.382-6.934 5.982-9.574-3.145-1.446-6.474-2.11-9.638-3.465-1.411-.604-1.831-2.024-1.325-3.413 2.942-8.078 9.274-14.809 13.596-22.165 4.509-7.676 8.885-15.788 13.62-23.385 2.546-4.086 5.024-8.022 7.641-12.842.101-1.829.249-3.699.249-5.53 0-3.643-.784-7.081-1.612-10.711-.395-1.73-.956-3.501-.982-5.287-2.277 1.118-4.151 2.277-6.296 3.629a62.37 62.37 0 0 1-12.881 6.143c-3.394 1.147-4.464 5.428-5.807 8.37-3.079 6.742-4.976 14.422-7.562 21.425-3.295 8.921-6.159 17.994-9.314 26.965-.619 1.76-1.423 3.456-1.796 5.294-.354 1.741-.818 5.62-3.177 5.382-2.602-.262-6.609-2.904-9.139-3.868l-.001.001c-.307.377-.671 1.001-1.055 1.771-.764 1.528-1.363 3.124-2.236 4.599l-.001.001c.762 1.442 2.459 1.984 3.359 3.307.498.733.749 1.601.378 2.449-.499 1.143-1.23 2.312-1.858 3.39-.553.95-1.38 1.874-2.594 1.66-1.053-.186-1.845-1.231-2.826-1.658-1.692-.738-3.615-.698-5.096-1.956-.631-.536-1.137-1.308-1.177-2.335-.036-.914.227-1.785.414-2.407l.013-.043c.521-1.728.257-3.14-1.058-4.506-.683-.708-.647-1.773-.015-2.496.772-.885 1.979-1.183 2.994-1.68 1.819-.892 3.611-1.038 3.605-3.531-.008-3.327.106-6.591.451-9.907l.623-5.849c.359-2.627.158-5.299.191-7.943.026-2.09.058-4.468.529-6.515.399-1.732 2.593-2.044 2.83-4.012.298-2.471.955-4.63.65-7.191-.201-1.685-.629-4.924.407-6.45-.592-.841-1.629-1.396-2.42-2.023-4.834-3.832-.965-12.866-.965-18.104 0-4.135-.537-8.728.149-12.769.352-2.067.462-4.175.727-6.254.247-1.938-1.311-3.543-3.229-3.961-3.44-.75-6.434-2.671-9.987-3.304-4.075-.727-8.235-.884-12.285-1.766-9.361-2.04-19.582-1.376-29.151-1.231zm45.308 150.779c.244-2.335 1.384-4.727 2.742-6.355 1.333-1.598 3.818-.78 5.214-2.24.899-1.939 2.035-4.916 2.217-7.033-1.786-.644-3.649-.905-5.543-.905-2.807 0-5.637.543-8.438.459-2.102-.062-3.067-1.215-4.427-2.558-.099.589-.114 1.209-.287 1.783-.577 1.907-.633 3.969-.754 6.225 2.214.727 4.14 2.194 6.163 3.314.732.405 1.499.991 1.553 1.9.068 1.127-.002 2.443-.57 3.446.124.89 1.462 1.562 2.13 1.964z"
            fill="#f5f500"
            fillRule="evenodd"
          />
          <path
            d="M27.257 161.002c8.64-4.32 18.514-8.657 22.371-10.285l2.057-21.343-3.6-2.315v-14.142l2.828-1.286 2.572-38.057c3.686-1.371 16.354-4.217 37.543-4.629s36.429 4.457 41.4 6.943v38.571l2.315 3.343v14.915l-3.086 1.028-.514 33.943-12.6 3.343 6.428 3.343-1.286 5.143 3.6 5.914 8.486 2.828 3.086-5.142-7.2-3.6 4.628-10.286 9.772 3.086L171 104.174l20.571-13.629 4.629 25.457-36.772 61.457 4.886 2.572 5.914 5.143-6.685 10.543-5.143-1.543-4.886-1.8-5.4 7.2-3.343 5.914-4.371-1.029-4.115 9.772 2.572 2.057-7.714 6.429-5.143-2.315 1.8-9.257 3.343-1.028 3.6-7.972-9.772-.771-6.428 3.085-5.4-4.885-1.543.771-1.543 6.943 8.486 6.943-1.543 3.6 6.685 5.657-2.057 4.371 3.343 3.6v12.6l5.4 7.2c-1.028.686-4.526 2.212-10.286 2.829s-10.8-.771-12.6-1.543l-2.314-15.171-9.771-4.629-1.543 4.629-7.971-2.572-2.829 1.029-4.371-1.029-5.4 1.029-3.343-4.372-5.914 17.229-10.286-1.029v-11.828c-4.886-3.6-17.177-13.577-27.257-24.686s-18.943-30-22.114-38.057c4.029-2.229 14.246-7.766 22.886-12.086z"
            fill="#fff"
          />
          <g fillRule="evenodd">
            <path
              d="M53.911 74.816c-.234.259-.426.727-.426 1.041s-.316.842-.702 1.174l-.702.603.046 7.034-.309 8.062c-.213.616-.418 2.732-.511 5.272l-.398 6.557-.248 4.073c-.004 1.359-.12 1.907-.513 2.406-.4.509-.45.756-.235 1.158.22.412.166.612-.279 1.026-.795.741-1.044 1.542-1.421 4.58-.594 4.775-.724 7.586-.398 8.575.406 1.229 1.634 2.251 4.116 3.424 1.138.537 2.069 1.04 2.069 1.116s-.474.139-1.054.139c-1.159 0-1.775.545-1.775 1.571 0 .322-.231.709-.514.86-.583.312-.662 1.054-.202 1.882a3.9 3.9 0 0 1 .389 1.204c.325 2.739.321 4.385-.024 8.518l-.702 9.02-.307 4.295-.734.256c-.88.307-.854.623-.329-3.924l.321-3.894c-.062-.287-.885.106-3.169 1.513l-5.408 3.326c-3.282 2.013-4.902 2.623-5.96 2.245-1.355-.484-2.647.398-2.647 1.809 0 .383-.186.495-.836.502-.46.005-1.112.163-1.45.35-.473.262-.789.275-1.371.055-.694-.262-.819-.216-1.509.557-.414.464-1.093.911-1.509.994-1.044.209-1.656.972-1.656 2.065 0 .723.19 1.09.894 1.723l4.964 4.108c.724.544 1.343 1.065 1.376 1.157s-1.726 1.258-3.91 2.59c-4.732 2.886-6.226 3.983-7.008 5.144-.742 1.1-.736 1.597.026 2.363.335.338.979 1.539 1.43 2.671 1.175 2.947 2.118 4.537 5.95 10.033 5.611 8.048 7.393 10.222 13.835 16.881l3.897 4.029-2.223 4.2c-2.268 4.284-2.748 5.794-2.18 6.857.321.599 2.576 2.206 4.395 3.13.636.323 2.06 1.294 3.165 2.158 3.127 2.444 3.558 2.726 4.162 2.726.311 0 .783.241 1.049.535.474.524.47.615-.221 4.693-.388 2.287-.704 4.877-.701 5.756.004 1.411.096 1.703.787 2.49 1.387 1.58 2.475 1.905 6.359 1.898 2.926-.006 3.499-.075 4.018-.483 1.299-1.021 5.041-9.416 5.041-11.308 0-.392.139-1.316.309-2.052.271-1.174.501-1.498 1.864-2.627 2.66-2.201 2.74-2.47 2.225-7.516-.159-1.556-.317-4.993-.351-7.639-.06-4.693-.049-4.808.452-4.697 1.394.308 10.459.657 15.943.615l6.171-.048-.129 3.185c-.118 2.92-.112 6.048.015 7.491.028.318-.033 1.794-.136 3.279-.153 2.208-.112 2.874.226 3.659.51 1.185 1.462 1.855 2.328 1.637.495-.124.73-.018 1.054.476.229.35.666.709.972.799 1.51.443 2.453 1.104 3.277 2.296 1.081 1.566 2.062 2.12 2.998 1.694.356-.162.719-.223.806-.136s.235 2.551.326 5.474.272 5.893.401 6.601c.538 2.951 1.2 3.214 8.098 3.214 4.777 0 5.487-.062 9.059-.791 4.44-.907 5.029-1.132 5.495-2.104.278-.581.278-.829.001-1.406-.671-1.401-.871-1.391-10.035.475-.669.136-2.172.213-3.34.172-2.603-.091-2.452.137-3.689-5.6-1.238-5.745-1.294-5.403 1.108-6.639 1.096-.564 3.016-1.438 4.267-1.941 5.067-2.041 6.626-3.762 4.938-5.449-.851-.852-1.624-.795-3.539.256a31.42 31.42 0 0 1-3.359 1.544c-.96.361-2.522 1.044-3.472 1.518-1.331.664-1.952.834-2.703.741-.701-.087-1.118.008-1.48.335-.42.381-.614.406-1.165.155-.364-.166-.753-.245-.864-.175s-.389-.08-.616-.33c-.452-.499-2.742-5.056-2.742-5.456 0-.136.408-.248.908-.248 2.626 0 11.153-4.307 13.441-6.79 1.343-1.456 1.574-2.283.894-3.197-.908-1.221-2.22-1.083-3.951.416-.624.541-1.598 1.257-2.164 1.591-3.153 1.862-4.874 2.721-7.042 3.514-2.288.836-2.439.859-2.898.444-.35-.317-.966-.444-2.215-.458l-1.731-.02.052-.771c.029-.425.132-2.524.23-4.664l.179-3.893 1.448-.164c2.383-.269 6.915-1.377 8.382-2.049s2.181-1.619 2.181-2.89c0-.385.202-.923.45-1.196.358-.395.476-1.129.578-3.599l.129-3.103.9-.495c.495-.272 1-.59 1.123-.707s1.008.606 1.968 1.605c1.668 1.736 1.786 1.809 2.687 1.663.518-.084 1.219-.027 1.557.127.831.379 1.922-.31 1.922-1.213 0-.677-1.894-5.13-2.459-5.782-.405-.466-.213-2.442.311-3.205.192-.279.346-.742.343-1.028-.004-.489-.893-2.277-1.856-3.736-.41-.62-.393-.693.461-2.045 1.467-2.323 1.097-3.854-.844-3.489-.778.145-1.475.698-3.603 2.854-1.45 1.47-3.129 2.984-3.731 3.365-2.666 1.687-6.682 2.139-9.065 1.021-.709-.333-1.882-1.238-2.615-2.018-1.29-1.371-3.171-4.055-3.171-4.523 0-.126 1.128-.301 2.507-.388s3.422-.4 4.541-.696c2.433-.644 7.818-3.026 9.941-4.398 4.112-2.658 6.255-5.876 5.03-7.552-.343-.469-.398-.467-2.121.071-2.255.703-5.787 1.135-8.584 1.051-1.218-.037-3.894.175-6.043.477-2.121.298-5.111.624-6.643.724l-2.786.182-.746-.905c-.634-.77-.991-.948-2.378-1.19-.897-.156-2.71-.284-4.029-.284-3.129 0-9.441-.716-10.393-1.179-.411-.2-1.394-.366-2.186-.368-2.41-.008-6.628-.715-7.8-1.307-.602-.305-1.906-1.024-2.896-1.599l-1.828-1.06c-.015-.008.064-.825.175-1.815s.28-6.313.375-11.829l.25-10.11c.043-.045.697.103 1.453.33 5.916 1.771 11.441 2.288 24.647 2.308 10.653.015 15.475-.274 21.729-1.303 3.222-.53 16.493-3.988 20.794-5.418 3.291-1.095 3.591-1.247 3.9-1.987.43-1.031 1.035-1.548 2.271-1.945l.993-.32-.608-.604-.607-.605-3.5.37-7.715.893c-6.622.821-20.005 1.805-24.548 1.805-2.274 0-7.134-.242-10.8-.538s-7.386-.474-8.266-.396c-2.056.183-6.811-.216-10.743-.901-1.697-.295-4.243-.63-5.657-.743-3.333-.266-4.995-.525-5.166-.803-.076-.123.106-.714.404-1.314.513-1.032.538-1.419.467-7.198-.042-3.359-.007-6.107.078-6.107s1.473.295 3.086.656c4.545 1.016 16.444 2.789 23.986 3.575 6.198.645 16.033.441 24.36-.505 3.569-.406 4.599-.69 4.599-1.267 0-.929-.889-1.007-13.628-1.193-8.708-.128-13.636-.31-16.329-.606-5.031-.551-18.718-2.519-21.811-3.135-.709-.142-.714-.157-.257-.661.41-.454.466-.995.454-4.412-.007-2.142.097-9.883.233-17.201.235-12.677.224-13.331-.219-13.821-.256-.283-.79-.514-1.186-.514-.425 0-.983-.263-1.363-.643-.445-.445-.944-.651-1.619-.669-1.474-.038-2.119-.296-2.463-.983-.668-1.331-2.813-1.979-3.615-1.092zm115.593 31.68c-1.171.714-1.808 2.228-3.509 8.349-2.448 8.809-7.739 24.449-11.309 33.429-.9 2.263-1.93 5.098-2.291 6.3l-4.03 13.974-.538 2.273.512 1.035.512 1.035-1.076-.172c-2.582-.415-6.778-.916-7.668-.916-.901 0-1.004-.081-1.48-1.158-.466-1.052-.594-1.157-1.408-1.157-.981 0-1.962.927-1.962 1.854 0 .274-.578 1.743-1.285 3.264s-1.286 3.05-1.286 3.396c0 1.148.787 1.801 4.018 3.331 1.75.828 3.182 1.616 3.182 1.751s-.478.626-1.063 1.089c-.958.759-2.271 2.917-2.277 3.745-.002.167.295.656.659 1.089.435.517.607.956.503 1.284-.203.64 1.12 2.184 2.456 2.865 1.413.721 5.078 1.295 8.465 1.327 2.887.027 3.518-.1 5.143-1.035.212-.122.964-.485 1.671-.807l1.8-.824c.283-.131.891-.812 1.352-1.512.615-.936 1-1.274 1.45-1.274.337 0 .859-.202 1.162-.45.863-.708 1.872-3.975 2.004-6.493.101-1.92.042-2.326-.484-3.339-.8-1.541-2.422-2.712-4.665-3.367l-5.537-1.673c-.248-.078-.137-.348.391-.95.801-.912 5.12-9.49 7.279-14.456 3.379-7.774 5.061-11.348 6.918-14.7 2.444-4.411 2.34-4.155 5.439-13.329 1.386-4.101 3.098-8.737 3.806-10.302s1.353-3.243 1.434-3.729c.185-1.115-.306-2.407-2.265-5.957-1.474-2.669-1.562-2.769-3.09-3.53-1.864-.926-1.843-.924-2.933-.26zM51.006 160.153c.303.381.623.939.71 1.239.15.517.095.538-1.001.371-.78-.118-1.313-.377-1.631-.789-.605-.788-.599-.866.095-1.201.903-.435 1.234-.366 1.827.38zm-15.779 14.216c.498.932 6.697 4.312 8.721 4.757l.804.177-1.182 1.315c-.65.723-1.414 1.769-1.697 2.324-.591 1.159-.696 3.219-.234 4.617.387 1.173 1.995 2.636 3.342 3.039.572.172 1.243.536 1.491.81.439.485.428.494-.453.328-1.297-.243-2.182.527-2.716 2.363-.524 1.802-.392 3.372.536 6.375.588 1.902.91 2.51 1.811 3.413l1.096 1.099-.796 2.095-.796 2.096-2.941-3.066c-1.617-1.686-3.846-4.15-4.952-5.475-2.665-3.192-8.929-12.154-11.519-16.479l-2.072-3.46 1.197-.783c1.97-1.288 9.706-5.996 9.904-6.026.101-.016.306.201.457.481zM52.095 178a4.77 4.77 0 0 0 1.133.873c1.049.543 12.359 3.557 17.432 4.647.583.125.585.134.129.91-.567.965-2.142 2.279-3.655 3.05-2.095 1.066-4.825.227-9.533-2.933-1.902-1.276-2.309-1.451-3.137-1.346-.924.117-.981.075-1.98-1.46-1.443-2.217-1.933-3.457-1.55-3.918.404-.487.586-.46 1.162.177zm25.251 5.344c1.642.834 4.951 1.742 8.025 2.202 5.483.82 4.821.501 6.289 3.033 2.424 4.181 3.783 5.91 5.305 6.753 1.361.754 1.476.771 5.191.799l3.799.028.883 1.001c.486.55.888 1.062.894 1.138.011.142-10.371 1.84-14.003 2.29a97.95 97.95 0 0 1-4.5.419c-2.503.168-13.113-.244-17.486-.679l-4.564-.408c-1.167-.091-2.122-.192-2.122-.224s.178-.484.394-1.002c.331-.792.352-1.359.129-3.53l-.265-2.788c0-.111.514-.278 1.143-.372 1.738-.261 4.124-1.581 5.958-3.296 1.248-1.167 1.91-2.068 2.716-3.696.587-1.184 1.11-2.152 1.163-2.152s.526.218 1.051.484zm52.735 13.658c-1.966.341-2.859 1.026-2.859 2.196 0 1.334.665 1.662 3.37 1.662 1.655 0 3.202.183 4.749.563 2.266.555 2.3.556 2.66.064.927-1.268.719-2.72-.494-3.458-1.401-.852-5.313-1.393-7.426-1.027zm8.834 4.258c-.773.541-.73 1.535.1 2.305 1.466 1.358 5.341 2.27 7.134 1.678 1.053-.347 1.115-.531.516-1.544-.565-.956-1.49-1.465-4.016-2.206-2.505-.735-2.975-.765-3.734-.233zm-31.001 1.768c-.078.203-.219 1.051-.313 1.886-.134 1.18-.074 1.708.266 2.366.343.663.368.892.115 1.048-.646.4-5.242 1.589-6.136 1.588-4.776-.006-24.429-.607-26.632-.815-4.157-.391-7.687-.817-7.907-.953-.106-.065-.193-1.048-.193-2.183V203.9l.964.155c4.922.789 18.273 1.339 22.882.942 3.128-.269 11.251-1.422 14.468-2.054 1.867-.366 2.648-.34 2.485.085zm28.454 1.043c-.3.211-1.036.644-1.634.964-.956.511-1.179.811-1.832 2.469a23.14 23.14 0 0 0-1.069 3.819c-.288 1.705-.368 1.881-.684 1.501-.197-.237-.812-.662-1.367-.945-.859-.439-1.121-.469-1.756-.206-.993.411-1.092.946-.937 5.026.15 3.921.475 4.824 1.687 4.683.862-.1 1.021-.601 1.228-3.872.121-1.921.244-2.507.524-2.507.201 0 .566-.331.812-.735.37-.608.525-.686.896-.452.733.462 1.299-.112 1.892-1.919.537-1.637.55-1.651 1.425-1.573.676.06 1.122-.111 1.899-.729 1.201-.954 1.396-1.226 1.401-1.954.002-.301.178-.691.39-.867.788-.654.423-2.149-.661-2.71-.924-.477-1.525-.475-2.214.007zM63.9 224.003c.238 0 .313.695.289 2.699-.027 2.277-.096 2.699-.439 2.7-.678.001-3.436-.574-3.648-.761-.109-.095.163-.971.604-1.944s.909-2.05 1.039-2.392c.202-.53.354-.598 1.035-.462.439.088.943.16 1.119.16z"
              fill="#000"
            />
            <path
              d="M77.683 67.696c-5.488.207-7.479.438-15.338 1.776-2.788.475-8.555 2.087-9.259 2.587-1.687 1.201-1.76 1.449-1.761 5.985a104.26 104.26 0 0 1-.38 8.13c-.736 7.73-1.773 23.185-1.608 23.967.033.159-.315.371-.773.471-1.922.419-2.224 1.378-2.226 7.062-.001 2.471.145 5.192.335 6.26.246 1.379.26 1.965.052 2.173-.811.81-.037 1.981 1.978 2.992.608.305 1.164.708 1.236.894s.007 1.946-.144 3.91l-.551 8.328c-.399 6.863-.213 6.375-2.747 7.226-5.767 1.937-36.441 17.209-42.29 21.055-2.068 1.359-2.55 2.217-1.843 3.282.484.729 2.92 5.824 3.659 7.651.587 1.454 5.181 10.001 7.186 13.372 3.572 6.004 8.684 13.106 13.142 18.257 8.119 9.38 20.455 20.986 24.461 23.012.636.322 1.226.693 1.31.823s-.064 1.244-.329 2.473c-.303 1.404-.5 3.45-.531 5.505-.044 2.942.004 3.342.481 3.986.807 1.09 3.309 1.678 7.298 1.714 3.674.034 5.283-.393 6.169-1.639.286-.4.932-2.214 1.436-4.03l1.292-4.458c1.625-5.03 2.255-6.695 2.455-6.494.126.126.358.965.517 1.866.288 1.637 1.057 2.828 1.826 2.828.191 0 1.48-.579 2.865-1.286s2.742-1.286 3.016-1.286 1.094.302 1.822.671c1.627.824 3.623.777 4.83-.116l.756-.559 1.872.875 2.901 1.306c.566.238 1.465.73 1.998 1.095.834.57 1.061.621 1.62.366.857-.39 1.396-1.742 1.396-3.501 0-1.137.083-1.423.414-1.423.595 0 6.925 3.3 7.457 3.888.363.402.546 1.703.987 7.026.615 7.429.505 7.125 3.069 8.421 4.187 2.115 12.288 2.251 19.314.323 3.689-1.012 5.232-1.732 5.694-2.66.432-.866.146-1.414-1.263-2.415-.674-.479-1.994-1.729-2.934-2.777s-1.776-1.934-1.859-1.97-.109-2.392-.059-5.237.01-6.057-.09-7.136c-.181-1.957-.185-1.966-1.574-3.305l-1.393-1.343.905-1.184c1.221-1.6 1.203-2.463-.076-3.682l-2.766-2.635c-.983-.935-1.951-2.006-2.15-2.379-.329-.614-.314-.735.161-1.257.793-.874.907-1.761.338-2.629-.27-.412-2.088-1.871-4.04-3.241l-3.549-2.491.09-1.451c.049-.798.223-2.393.387-3.544l.298-2.092 1.309 1.794c1.375 1.884 2.517 2.662 3.91 2.662 1.341 0 3.823-.927 5.443-2.032 1.169-.799 1.671-1.008 2.004-.835.66.343 3.638.81 5.166.81.904 0 1.382.116 1.475.357.133.347-2.243 5.388-2.662 5.647-.115.071-.747.014-1.406-.127-1.405-.299-2.07-.042-2.615 1.011-.717 1.387-1.696 8.398-1.484 10.624.08.834.258 1.141.881 1.52 1.044.635 4.989 1.877 5.881 1.852.933-.027 2.961-1.545 6.142-4.598 2.957-2.838 3.689-3.863 3.448-4.825-.155-.619-.985-1.467-2.035-2.082-.415-.243-.358-.472.704-2.829l1.31-3.017c.135-.396.376-.432 1.951-.285 2.27.211 2.714-.055 4-2.395 1.182-2.151 1.705-2.78 3.774-4.544 1.535-1.309 1.68-1.531 2.516-3.863 1.037-2.892 1.299-3.02 3.291-1.609.672.477 2.349 1.238 3.726 1.692s2.571.933 2.651 1.063.479.237.886.237c.558 0 .957-.268 1.63-1.093 1.258-1.544 3.26-4.62 4.657-7.157.656-1.191 1.431-2.469 1.724-2.841.665-.848.488-1.885-.497-2.899-1.305-1.343-4.254-3.474-5.049-3.648-1.325-.291-4.503-2.234-4.512-2.759-.005-.257.321-.952.724-1.543s2.276-3.678 4.161-6.86l7.146-11.7 10.85-17.872c9.032-16.121 11.645-20.451 12.785-21.189.546-.354.887-.818.989-1.349.534-2.786-3.268-22.429-5.074-26.211-.546-1.143-.696-1.273-1.557-1.344s-1.677.408-8.871 5.241l-9.976 6.815c-3.424 2.488-3.755 3.022-6.087 9.84l-3.683 10.712-3.467 10.029-2.958 8.357-3.73 10.286c-1.483 4.177-2.318 6.292-4.352 11.02-1.104 2.566-2.336 5.678-2.739 6.916s-.86 2.25-1.016 2.25-1.434-.449-2.841-.998c-4.174-1.626-4.985-1.857-5.916-1.682-1.006.189-1.2.481-3.142 4.737-.741 1.626-1.752 3.734-2.244 4.684-1.426 2.748-1.489 2.649 3.282 5.187 1.521.809 2.765 1.5 2.765 1.536s-.29.456-.643.936-.643 1.092-.643 1.363c0 .368-.114.445-.45.306-.247-.103-1.863-.665-3.59-1.249s-3.144-1.172-3.15-1.306-.602-1.143-1.325-2.245l-1.316-2.004.396-.988c.565-1.413.796-4.439.379-4.959-.496-.618-1.812-1.226-3.067-1.417-2.055-.313-1.813-.517 1.63-1.379 1.882-.47 4.047-1.07 4.812-1.332s1.591-.476 1.836-.476.718-.221 1.052-.492l.607-.492v-11.786c0-7.686.126-13.443.361-16.544.389-5.132.482-5.4 1.868-5.4 1.478 0 1.528-.332 1.446-9.651l-.075-8.423-.743-.542c-.408-.298-.987-.734-1.285-.969l-.543-.427.058-16.286c.067-18.804-.022-21.237-.814-22.417-.742-1.106-2.476-1.994-6.305-3.23-9.037-2.916-19.3-4.382-31.896-4.556l-10.286-.167c-1.485-.034-4.667.013-7.071.104zm29.314 3.397c9.987 1.305 16.923 2.815 21.728 4.732.92.367 1.84.819 2.046 1.005.273.247.407 1.184.498 3.491.176 4.482.176 4.628-.032 18.838-.103 7.072-.093 13.957.023 15.301s.143 2.52.06 2.614c-.23.26-10.045 1.436-15.709 1.88-7.316.575-16.82.894-27.771.932l-9.643.033 2.829.476c7.723 1.301 22.123 2.107 31.629 1.772 9.154-.323 13.709-.868 18.257-2.186l2.318-.636c.069 0 .125 2.768.125 6.152v6.151l-.836.268c-4.117 1.321-9.537 2.502-17.807 3.879l-5.657.941 1.8.369c1.271.26 3.538.365 7.714.355 5.995-.014 6.507-.072 11.291-1.287l.748-.19-.234 5.374c-.258 5.942-.299 13.646-.108 20.206.068 2.359.034 4.38-.077 4.491-.222.222-.957.432-6.091 1.744-5.307 1.355-12.938 2.634-19.446 3.259-2.685.258-4.663.26-9.684.013-12.892-.635-22.816-2.363-33.087-5.76-5.142-1.702-11.832-5.398-11.44-6.322.1-.236.224-1.007.275-1.714s.32-3.6.598-6.429l.77-9c.365-5.327.844-10.671.957-10.671.051 0 1.278.397 2.725.883 5.24 1.76 8.435 2.499 14.074 3.257 4.48.602 18.445.284 15.686-.357-.353-.082-2.263-.339-4.243-.571-4.396-.515-11.572-1.863-16.437-3.089-3.535-.891-13.552-4.035-14.263-4.476-.666-.414-1.288-8.983-.892-12.286l.161-1.339.93.4c3.27 1.409 7.152 2.44 11.473 3.047l3.729.541c.592.095.812.058.643-.109-.566-.557-14.012-6.215-14.769-6.215-.211 0-.263-.162-.146-.45.416-1.03.834-5.737 1.682-18.965l.504-6.366c.141-1.38.333-4.018.426-5.862.148-2.928.222-3.332.579-3.186 1.849.755 5.064 1.743 7.507 2.308 7.069 1.633 11.724 2.174 20.288 2.359 5.927.128 12.055-.041 11.771-.325-.051-.051-2.171-.336-4.71-.633-5.184-.606-14.094-1.972-19.371-2.969-3.802-.719-12.685-2.693-12.882-2.864-.72-.624 11.072-2.777 17.864-3.261.707-.05 7.419-.062 14.914-.024 10.575.052 14.32.158 16.715.47zm83.7 22.12c0 .053.29 1.47.645 3.15 1.559 7.383 2.692 13.553 2.983 16.24l.315 2.901-.791.828c-.809.847-3.924 5.533-3.924 5.904 0 .113-.271.637-.604 1.164s-1.508 2.578-2.614 4.556-3.021 5.292-4.257 7.363l-3.017 5.146c-.423.759-1.47 2.537-2.326 3.952l-2.475 4.114a129.32 129.32 0 0 1-1.877 3.033c-3.251 5.059-8.393 13.406-10.972 17.811l-3.452 5.724-.45.597-1.751-.719c-.963-.396-1.81-.872-1.882-1.06s.224-1.115.657-2.063 1.499-3.517 2.37-5.709c1.772-4.461 3.886-9.135 9.247-20.443 5.999-12.653 10.662-23.028 11.946-26.577l.591-1.635 2.926-.073c2.485-.063 3.372-.21 5.883-.978 1.627-.498 3.594-1.146 4.372-1.442l1.414-.537-2.186.134-6.252.381c-2.237.135-4.161.304-4.275.375s-1.004-1.042-1.976-2.473l-4.533-6.512c-.671-.936-1.217-1.783-1.212-1.882s1.486-1.134 3.293-2.299 5.534-3.676 8.284-5.579c4.236-2.932 5.9-3.889 5.9-3.392zm-16.589 18.315l2.784 4.268-.919 1.71c-.505.941-2.301 4.719-3.991 8.396l-3.722 8.1-1.675 3.6-9.438 20.186c-1.177 2.6-1.885 4.265-3.222 7.586-2.216 5.5-3.061 7.256-3.417 7.101-.171-.074-.803-.28-1.404-.457s-1.093-.466-1.093-.641c0-.616 1.637-4.895 3.868-10.117 1.239-2.9 3.379-8.28 4.756-11.958 2.772-7.406 13.878-39.694 14.148-41.131.094-.502.254-.911.356-.911s1.438 1.92 2.969 4.268zM48.138 154.51c-.437 4.341-.454 4.947-.163 5.829.397 1.202 2.309 2.645 6.481 4.891.662.357 1.259.739 1.328.85s-.762.659-1.846 1.218-2.855 1.627-3.935 2.373c-2.061 1.421-2.542 2.186-2.008 3.185.422.789.207 1.064-1.701 2.175-1.901 1.107-5.279 4.132-6.352 5.689-.818 1.187-1.226 2.887-1.247 5.202-.024 2.566.401 3.83 1.695 5.038 1.391 1.298 4.652 3.129 6.184 3.472 1.336.3 3.935-.178 5.561-1.022.516-.268.987-.439 1.045-.381s.002 1.004-.126 2.1c-.314 2.699.008 3.757 1.349 4.441.551.281 1.074.628 1.163.772s-.027 1.467-.258 2.94c-.35 2.233-.632 3.096-1.699 5.197-1.396 2.751-2.092 3.786-3.629 5.397-1.393 1.46-1.293 2.242.43 3.367 2.275 1.485 2.293 1.523 1.529 3.16-1.279 2.739-2.736 6.544-2.86 7.47-.116.864-.047.986.866 1.555.545.34 1.426.814 1.957 1.055.91.412.966.504.966 1.607 0 .643-.103 1.17-.229 1.17s-.907-.5-1.736-1.111c-3.583-2.64-6.769-5.512-12.435-11.209-8.504-8.55-12.83-13.749-18.742-22.523-5.018-7.447-7.914-12.586-12.091-21.453-1.478-3.138-1.587-3.482-1.195-3.769.237-.174 3.057-1.71 6.266-3.415l8.02-4.28c2.909-1.572 13.856-6.96 14.61-7.19.328-.1 2.295-.934 4.371-1.854 5.588-2.476 7.849-3.415 8.235-3.42.266-.004.311.333.196 1.474zm15.119 14.309c.976.372 2.118.736 2.536.81s1.587.357 2.596.631c2.964.803 6.578 1.559 8.649 1.81l6.814.866c8.456 1.095 10.558 1.234 16.987 1.122 5.051-.087 6.998-.235 10.844-.822l4.689-.715.767.645c.421.355 1.725.961 2.897 1.347s2.169.735 2.217.776-1.036 1.656-2.41 3.591c-3.104 4.372-4.353 6.414-4.768 7.802-.366 1.22-.109 1.735.732 1.468.687-.218 3.233-2.733 5.073-5.011l1.508-1.866.478.6c.736.925.474 2.665-.782 5.176-1.763 3.528-4.917 6.217-8.816 7.518-2.21.738-2.677 1.034-2.92 1.852-.227.764.855 1.869 1.829 1.869.426 0 .609.091.462.23-.239.225-5.322.905-12.661 1.694-4 .43-6.429.745-9.13 1.185-1.39.226-1.689.352-1.468.62.335.403 3.92 1.076 6.943 1.303 2.334.175 9.301-.253 11.38-.699.691-.148 1.306-.219 1.367-.157s.036.83-.056 1.708c-.16 1.534-.204 1.614-1.093 1.99-2.575 1.09-14.299 3.39-19.641 3.853-1.1.096-2.056.264-2.123.374-.177.287 3.168 1.001 5.843 1.248 1.256.116 2.341.268 2.41.338s.016.419-.119.775c-.358.941-1.014 8.003-1.309 14.081-.289 5.967-.491 8.229-.734 8.228s-3.679-1.417-4.617-1.902c-1.237-.639-2.949-.537-3.862.231-.936.788-.914.788-2.469-.001-1.57-.797-3.338-.842-4.908-.127-.622.284-1.391.544-1.709.579-.737.081-.767-.097-1.63-9.451-.824-8.922-1.27-11.577-2.083-12.39-.761-.76-1.258-.752-2.045.036-.684.684-.789 1.591-.386 3.329.128.552.312 1.853.41 2.893l.177 1.889-1.638-.009c-2.095-.011-5.134-.56-6.78-1.225-3.85-1.554-7.047-3.242-7.064-3.731-.004-.114.335-.635.753-1.157s1.208-1.759 1.756-2.749 1.102-1.771 1.233-1.735 1.105.38 2.166.763c1.61.582 2.359.699 4.537.706 2.211.007 2.691-.066 3.15-.481.298-.27.542-.59.542-.711 0-.401-1.642-1.245-3.471-1.785-3.412-1.007-5.781-1.812-5.901-2.007-.113-.184.283-3.388.502-4.057.074-.228.538-.182 1.782.174 2.257.645 5.909 1.234 8.888 1.434 2.545.171 8.445-.257 8.827-.64.546-.546-4.545-1.914-11.142-2.995-4.502-.737-7.58-1.573-9.645-2.617l-1.541-.78v-2.792c0-1.535-.094-2.936-.208-3.113-.297-.459-3.709-.412-6.221.086-1.985.393-2.107.388-3.471-.127-.778-.293-1.993-.973-2.7-1.509-1.263-.958-1.287-1.003-1.367-2.509-.161-3.034.059-3.627 2.098-5.66 1.669-1.665 3.696-3.202 4.221-3.202.113 0 .521.726.908 1.613 1.999 4.59 5.954 8.672 8.401 8.672.65 0 .782-.102.782-.606 0-.723-.673-1.754-2.796-4.282-.867-1.032-1.576-2.023-1.576-2.201s-.092-.363-.205-.411c-.297-.124-2.226-4.217-2.754-5.845l-.45-1.388.606-.457c.333-.251 2.312-1.346 4.397-2.433s3.916-2.128 4.069-2.312c.314-.378.686-.296 3.441.752zm82.954 5.73c7.203 2.614 10.34 3.939 10.847 4.583.403.513.735.642 1.651.642.631 0 1.535.162 2.01.36l.862.361-2.834 5.618-2.909 5.705c-.04.048-.69-.372-1.443-.935-2.662-1.989-11.98-7.556-18.803-11.235-1.243-.67-2.222-1.293-2.174-1.382a931.39 931.39 0 0 0 1.82-3.661l1.734-3.497 3.013 1.137 6.226 2.304zm20.162 9.018c.768.672 1.405 1.413 1.417 1.647.019.391-2.284 4.912-3.959 7.769-.833 1.423-1.103 1.456-3.379.424l-1.691-.766.967-1.741c.531-.957 1.641-2.865 2.467-4.239s1.697-2.908 1.935-3.408.526-.908.64-.908.835.55 1.603 1.222zm-23.815 3.566c9.719 5.495 9.792 5.542 9.068 5.798-.133.047-.567.794-.964 1.66-.596 1.298-1.078 1.861-2.753 3.214-1.556 1.256-2.308 2.102-3.215 3.612-.651 1.084-1.247 2.035-1.325 2.113-.145.145-3.033-.657-3.577-.993-.222-.137-.203-.297.073-.61.604-.687 1.298-5.211 1.098-7.162-.202-1.971-.571-2.935-1.621-4.239-.419-.521-.957-1.456-1.194-2.077l-.432-1.131.84-.929c.463-.511.875-.936.916-.944s1.431.752 3.086 1.688zm-16.276 3.698c.245 1.485.528 2.853.629 3.04.119.221.449-.233.935-1.286.606-1.313.747-1.959.731-3.361-.011-.955.065-1.736.169-1.736s.749.29 1.434.644 2.203.982 3.374 1.395c2.233.788 2.779 1.236 3.652 2.992.374.754.517 1.544.511 2.829-.009 2.072-.854 6.135-1.136 5.465-.291-.69-1.386-.908-3.923-.781-1.302.065-2.886.04-3.519-.055l-1.153-.173.37-1.047c.524-1.487.474-2.452-.145-2.783-.728-.39-1.186-.086-3.797 2.525-2.315 2.313-3.969 3.339-5.778 3.583-1.029.139-1.251-.03-3.846-2.934l-.949-1.063 1.592-.684c2.09-.898 4.099-2.237 5.466-3.644.988-1.017 1.603-1.847 3.931-5.312.81-1.204.881-1.087 1.452 2.386zm11.561 14.653c.359.136.654.361.654.498s-.752 1.625-1.672 3.306-1.671 3.192-1.671 3.357c0 .454-.801.359-1.726-.205l-.826-.504.627-1.418c.345-.78 1.099-2.357 1.677-3.505 1.134-2.256 1.088-2.232 2.937-1.529zm-28.694 4.311c.264.248 1.941 1.492 3.727 2.765s3.248 2.435 3.249 2.583c.002.773-3.536 3.414-6.523 4.869-2.675 1.302-7.754 2.671-11.584 3.121-1.388.163-1.484.141-1.354-.313.203-.706.748-9.346.647-10.26-.073-.662.007-.781.558-.834 3.656-.35 8.471-1.386 9.667-2.08.691-.402 1.062-.368 1.614.149zm20.022 3.959c.484.645 2.95 1.956 4.859 2.583l1.708.561-.871.753c-.479.414-1.265 1.116-1.748 1.56s-1.202 1.047-1.599 1.341l-.72.535-1.745-.564c-1.442-.466-1.76-.67-1.834-1.177-.1-.672.454-6.146.654-6.478.138-.226.803.229 1.296.886zm-10.523 8.127c2.619 2.595 2.721 2.738 2.386 3.364-.458.856-3.972 3.323-6.282 4.41s-7.172 2.416-7.944 2.171c-.25-.079-.454-.257-.454-.396s-.242-.739-.537-1.333c-.573-1.152-1.806-4.358-1.708-4.44.033-.027 1.158-.36 2.502-.741 2.534-.718 7.16-2.98 8.742-4.274.496-.405.987-.741 1.092-.745s1.096.888 2.203 1.984zm-59.865-.02c3.213 1.276 5.258 1.693 8.297 1.691 1.24-.001 2.298.071 2.352.16s.181 1.29.284 2.669l.186 2.507-5.238-.009c-5.442-.009-7.854-.288-10.509-1.217-.778-.272-1.414-.599-1.414-.727 0-.412 3.009-6.302 3.179-6.223.09.042 1.379.559 2.864 1.149zm43.326 8.371c.85 2.059 1.704 3.93 1.898 4.157.553.648.12.504-2.521-.833-1.353-.685-3.137-1.513-3.963-1.84-1.44-.568-1.497-.625-1.35-1.357.084-.42.153-1.439.153-2.263v-1.5l1.864-.086c1.026-.047 1.979-.072 2.119-.054s.95 1.716 1.8 3.776zm21.157 7.923l.113 6.227.85 1.631a24.87 24.87 0 0 0 2.071 3.184c.671.855 1.173 1.594 1.115 1.642-.505.43-7.549 1.835-7.376 1.472.04-.083.52-.814 1.068-1.624 1.297-1.916 1.288-3.264-.023-3.281-.841-.01-3.462 3.051-3.815 4.457-.198.79-.788.853-3.844.412-2.883-.416-4.514-1.019-4.803-1.778-.262-.688-.781-6.21-.601-6.39.058-.058.603.064 1.212.271 1.625.554 6.227.39 8.654-.306 3.266-.938 4.789-1.973 4.623-3.141-.122-.867-1.342-.892-4.784-.099-1.699.391-3.626.656-4.774.656-1.672 0-2.139-.111-3.554-.843-1.54-.796-1.647-.911-1.941-2.096-.311-1.255-1.416-2.718-2.051-2.718-.186 0-.337-.145-.336-.321.001-.224.567-.333 1.864-.36 3.501-.071 9.081-1.898 12.288-4.023l1.66-1.1 1.136.95 1.136.951.112 6.227zm-60.948-5.756c2.44.092 4.433.236 4.431.321s-.456 1.542-1.006 3.24c-.611 1.883-1.121 3.056-1.309 3.011-4.105-.984-5.061-1.016-5.44-.183-.662 1.453 1.208 2.94 3.711 2.952.672.003 1.221.094 1.221.203 0 .171-.799 3.205-1.179 4.473-.289.967-3.572 1.284-6.664.645-1.499-.31-1.546-.345-1.632-1.21-.127-1.277.449-5.254 1.022-7.063.269-.848.627-2.738.796-4.198.307-2.654.307-2.655.96-2.506.359.082 2.649.224 5.089.315z"
              fill="#323239"
            />
          </g>
        </g>
      </g>
      <defs>
        <clipPath id="A">
          <path
            d="M0 0h245.556v245.556H0z"
            fill="#fff"
            transform="translate(14.444)"
          />
        </clipPath>
        <clipPath id="B">
          <path
            d="M0 0h200.571v200.571H0z"
            fill="#fff"
            transform="translate(0 59.429)"
          />
        </clipPath>
        <clipPath id="C">
          <path
            d="M0 0h200.571v200.571H0z"
            fill="#fff"
            transform="translate(0 59.429)"
          />
        </clipPath>
      </defs>
    </svg>
  );
};
GlowReportChannel.displayName = 'GlowReportChannel';
