# Adding New SVGs

1. Take the provided SVG file and optimize using [this](https://vecta.io/nano)
   tool. Many direct from Illustrator / Figma provided SVGs are not optimized
   for web. This can save 10-40% on size.

2. Open the resulting SVG file in a text editor and paste the output into the
   JSX return statement of the corresponding SVG React component.

3. Ensure the SVG tag has the following properties:

```tsx
<svg
  xmlns="http://www.w3.org/2000/svg"
  role="img"
  // x and y correspond to the original width and height of the svg (you most
  // likely will not need to alter these and they'll have been handled by the
  // transformer)
  viewBox="0 0 x y"
  width="100%"
  height="100%"
  preserveAspectRatio="xMidYMid meet"
>
```

4. Add the new SVG to the `svgExamples` array in the `more-ui` package example
   to allow quick visualization of the available assets.

## FAQ

**What are "Glow" SVGs?**

Read about Glow SVGs
[here](https://design.xarth.tv/user-interface/guidelines/ultraviolet-glow).

**How do I import "Glow" SVGs?**

Ask your design for the Glow asset and follow the process above.
