import type { FC } from 'react';
import { createGlobalStyle } from 'styled-components';
import { tachyonStyleOverrides } from '../sc-mixins';
import { ROOT_FONT_SIZE_VW } from './config';

// body's position: fixed helps lock everything into a proper app-like experience
// istanbul ignore next: trivial
const styleString = `html {
  font-size: ${ROOT_FONT_SIZE_VW}vw !important;
}

body {
  position: fixed;
}

a {
  outline: none;
}

${tachyonStyleOverrides}
`;

// istanbul ignore next: trivial
/**
 * styled-components version of shared tv root styles using `createGlobalStyle`.
 * Used for things like CRA where the application root is in client-side code.
 */
export const ScTvStyles = createGlobalStyle`${styleString}`;

// istanbul ignore next: trivial
/**
 * Raw style tag version of shared tv root styles. Used for things like Next
 * _document where elements need to be fully baked for inclusion (since
 * css-in-js flush() contexts are not available).
 */
export const TvStyles: FC = () => (
  // No XSS risk here because the content is static
  <style dangerouslySetInnerHTML={{ __html: styleString }} />
);
TvStyles.displayName = 'TvStyles';
