// When changing this value, it is important to get as close to the actual
// scaling value as possible (eg. 1.8 vs 1.805), as these differences add up
// across the size of a TV and can easily lead to off-by-one pixel differences
// which can break nav behavior, reveal unhoverable components, etc. For
// example, at 1.6x we had to switch the constant from 0.83 to 0.83333 in order
// to minimize bad rounding and help the browser reach perfect alignment at the
// pixel level.

/**
 * The value applied html font-size, setting the base rem size and scaling all
 * core-ui components. core-ui uses 10px by default.
 *
 * 720x1280 => 1280 / 100 * 0.9375 => 12px (1.2x scaling)
 * 1080 => 1920 / 100 * 0.9375 => 18px (1.8x scaling)
 *
 * Our design team has decided that a font-size value of 18px was most optimal
 * for font legibility at far distances.
 */
export const ROOT_FONT_SIZE_VW = 0.9375;
