// Notes about image-width lists:
//
// The first item is the default item. Various utilities rely on this.
//
// We've started transitioning to use Starshot as a basis since it has an easier
// ramp to understand, and that ramp provides plenty of breakpoints for mobile
// devices (and in fact aren't that different from the previous mobile-derived
// ramps anyway).
//
// We use Starshot's 720p size as the default size because that that size range
// is very common for mobile devices, and prevents double image downloads in
// older browsers. It is also a good compromise in general between size and
// quality.

/**
 * String with proper substitution tokens for dynamic width and height resizing
 * for srcSet generation. Replace hard-coded image dimensions with this string
 * to make the image source url compatible with our srcSet utilities.
 */
export const STANDARD_TEMPLATE_FRAGMENT = '-{width}x{height}';

//  Box Art
export const BOX_ART_IMAGE_WIDTHS = [
  // ~720p SST (default)
  138,
  // arbitrary small
  52,
  // ~1080p SST
  208,
  // 2x ~720p (1440p)
  276,
  // 2x ~1080p (2K)
  416,
  // 3x ~1080p
  624,
  // 4x ~1080p (4K)
  832,
];
export const BOX_ART_ASPECT_RATIO = 4 / 3;
export const BOX_ART_DEFAULT_WIDTH = BOX_ART_IMAGE_WIDTHS[0];
export const BOX_ART_DEFAULT_HEIGHT =
  BOX_ART_DEFAULT_WIDTH * BOX_ART_ASPECT_RATIO;
export const BOX_ART_DEFAULT_URL =
  'https://static-cdn.jtvnw.net/ttv-static/404_boxart-{width}x{height}.jpg';

// Stream thumbnails
export const CHANNEL_THUMBNAIL_IMAGE_WIDTHS = [
  // ~720p SST (default)
  276,
  // arbitrary small
  80,
  // ~1080p SST
  414,
  // 2x ~720p (1440p)
  552,
  // 2x ~1080p (2K)
  828,
  // 3x ~1080p
  1242,
  // 4x ~1080p (4K)
  1656,
];
export const CHANNEL_THUMBNAIL_ASPECT_RATIO = 9 / 16;
export const CHANNEL_THUMBNAIL_DEFAULT_WIDTH =
  CHANNEL_THUMBNAIL_IMAGE_WIDTHS[0];
export const CHANNEL_THUMBNAIL_DEFAULT_HEIGHT =
  CHANNEL_THUMBNAIL_DEFAULT_WIDTH * CHANNEL_THUMBNAIL_ASPECT_RATIO;
export const CHANNEL_THUMBNAIL_DEFAULT_URL =
  'https://static-cdn.jtvnw.net/ttv-static/404_preview-{width}x{height}.jpg';

// gives only 320 and 640 for 404 images since they are not fronted by resizing support
export const OVERLAY_404_IMAGE_WIDTHS = [
  // default
  320, 640,
];
export const OVERLAY_IMAGE_WIDTHS = [
  // include 404 widths since these are used interchangeably
  ...OVERLAY_404_IMAGE_WIDTHS,
  // continue 320px multiples
  960,
  1280,
];
export const OVERLAY_ASPECT_RATIO = 9 / 16;

export const CHANNEL_BANNER_IMAGE_WIDTHS = [
  // default
  320, 640, 960, 1280,
];
export const CHANNEL_BANNER_ASPECT_RATIO = 1 / 2;
