import type { TwitchIntl } from 'tachyon-intl';

export function formatFollowers(intl: TwitchIntl, followers: number): string {
  const { formatMessage, formatNumberShort } = intl;
  const formattedFollowers = formatNumberShort(followers);

  return formatMessage(
    '{followers, plural, one {{formattedFollowers} follower} other {{formattedFollowers} followers}}',
    { followers, formattedFollowers },
    'Followers',
  );
}
