import { DefaultTwitchIntl } from 'tachyon-intl';
import { formatTimeRange } from './formatTimeRange';

jest.spyOn(DefaultTwitchIntl, 'formatTime');

describe(formatTimeRange, () => {
  it("only returns short format of the start time when end doesn't exist", () => {
    const start = new Date();
    const end = null;

    const formatted = formatTimeRange(DefaultTwitchIntl, start, end);
    expect(formatted).toBe(DefaultTwitchIntl.formatTime(start, 'short'));
  });

  it('returns a short format of both start and end when they are at same day', () => {
    const start = new Date();
    const end = new Date();

    const formatted = formatTimeRange(DefaultTwitchIntl, start, end);
    expect(formatted).toBe(
      `${DefaultTwitchIntl.formatTime(
        start,
        'short',
      )} - ${DefaultTwitchIntl.formatTime(end, 'short')}`,
    );
  });

  it('returns a long format of both start and end when they are not at the same day', () => {
    const start = new Date();
    const end = new Date();
    end.setDate(end.getDate());

    const formatted = formatTimeRange(DefaultTwitchIntl, start, end);
    expect(formatted).toBe(
      `${DefaultTwitchIntl.formatTime(
        start,
        'long',
      )} - ${DefaultTwitchIntl.formatTime(end, 'long')}`,
    );
  });
});
