import type { TwitchIntl } from 'twitch-intl';

// istanbul ignore next: trivial
/**
 * Returns a formatted time range label.
 * If end doesn't exist it only returns the time of the start date.
 * If end exists and they are on the same day, it returns the time range.
 * If end exists but they are not on the same day, it will include the day
 * label in the range string as well.
 *
 * @param intl TwitchIntl
 * @param start start date
 * @param end end date, can be `null`
 */
export function formatTimeRange(
  { formatTime }: TwitchIntl,
  start: Date,
  end: Date | null,
): string {
  const startShort = formatTime(start, 'short');
  if (end) {
    const startLong = formatTime(start, 'long');
    const endShort = formatTime(end, 'short');
    const endLong = formatTime(end, 'long');
    if (end.getDate() !== start.getDate()) {
      return `${startLong} - ${endLong}`;
    }

    return `${startShort} - ${endShort}`;
  }

  return startShort;
}
