import type { FormatMessage } from 'tachyon-intl';

/**
 * Correctly formats view count for display or aria label. Optionally pass a
 * pre-formatted version of the value to customize the display.
 *
 * Note that this is subtly different from formatLiveViewersCount, which is
 * suitable for indicating number of live viewers as opposed to number of total
 * views.
 *
 * @example
 * const viewCountFormatted = formatNumberShort(props.viewCount);
 * return (
 *    <CoreText>
 *      {formatTotalViewCount(formatMessage, props.viewCount, viewCountFormatted)}
 *    </CoreText>
 * );
 */

// istanbul ignore next: trivial
export function formatTotalViewCount(
  formatMessage: FormatMessage,
  viewCount: number,
  formattedViewCount?: string,
): string {
  if (formattedViewCount) {
    return formatMessage(
      '{viewCount, plural, one {1 view} other {{formattedViewCount} views}}',
      { formattedViewCount, viewCount },
      'ViewCount',
    );
  }
  return formatMessage(
    '{viewCount, plural, one {1 view} other {# views}}',
    { viewCount },
    'ViewCount',
  );
}
