import type { ReactChild } from 'react';
import { CoreText, TextType } from 'twitch-core-ui';

// istanbul ignore next: trivial
/**
 * For rendering bold text, commonly used in `formatMessage` for x:strong.
 */
export const strongText = (children: ReactChild): JSX.Element => (
  <CoreText bold type={TextType.Span}>
    {children}
  </CoreText>
);
